/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ITileStructure;
import forestry.core.gadgets.BlockForestry;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    public BlockStructure(Material material) {
        super(material);
        this.func_149711_c(1.0f);
    }

    public boolean func_149700_E() {
        return false;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        ITileStructure central;
        ITileStructure structure;
        TileEntity tile = world.func_147438_o(x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
        if (tile instanceof ITileStructure && (structure = (ITileStructure)tile).isIntegratedIntoStructure() && !structure.isMaster() && (central = structure.getCentralTE()) != null) {
            central.validateStructure();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        TileForestry tile = (TileForestry)world.func_147438_o(x, y, z);
        if (!Utils.isUseableByPlayer(player, tile)) {
            return false;
        }
        if (tile instanceof ITileStructure && !((ITileStructure)((Object)tile)).isIntegratedIntoStructure()) {
            return false;
        }
        if (Proxies.common.isSimulating(world)) {
            if (tile.allowsViewing(player)) {
                tile.openGui(player);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.accesslocked", new Object[]{PlayerUtil.getOwnerName(tile)}));
            }
        }
        return true;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        super.func_149695_a(world, x, y, z, neighbor);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof ITileStructure)) {
            return;
        }
        ((ITileStructure)tile).validateStructure();
    }

    public static enum EnumStructureState {
        VALID,
        INVALID,
        INDETERMINATE;

    }
}

