/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public abstract class GuiAlyzer
extends GuiForestry<ContainerAlyzer, IInventory> {
    protected static final int COLUMN_0 = 12;
    protected static final int COLUMN_1 = 85;
    protected static final int COLUMN_2 = 150;
    protected final ISpeciesRoot speciesRoot;
    protected final IBreedingTracker breedingTracker;
    protected final String guiName;
    protected HashMap<String, ItemStack> iconStacks = new HashMap();

    public GuiAlyzer(String speciesRoot, EntityPlayer player, ContainerAlyzer container, IInventory inventory, String guiName) {
        super("textures/gui/beealyzer2.png", container, inventory);
        this.field_146999_f = 246;
        this.field_147000_g = 238;
        this.guiName = guiName;
        this.speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(speciesRoot);
        this.breedingTracker = this.speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
    }

    protected final int getColorCoding(boolean dominant) {
        if (dominant) {
            return this.fontColor.get("gui.beealyzer.dominant");
        }
        return this.fontColor.get("gui.beealyzer.recessive");
    }

    protected final void drawLine(String text, int x, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    protected final void drawRow(String text0, String text1, String text2, IIndividual individual, IChromosomeType chromosome) {
        this.drawRow(text0, text1, text2, this.fontColor.get("gui.screen"), this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()), this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
    }

    protected final void drawChromosomeRow(String chromosomeName, IIndividual individual, IChromosomeType chromosome) {
        IAllele active = individual.getGenome().getActiveAllele(chromosome);
        IAllele inactive = individual.getGenome().getInactiveAllele(chromosome);
        this.drawRow(chromosomeName, active.getName(), inactive.getName(), this.fontColor.get("gui.screen"), this.getColorCoding(active.isDominant()), this.getColorCoding(inactive.isDominant()));
    }

    protected final void drawSpeciesRow(String text0, IIndividual individual, IChromosomeType chromosome, String customPrimaryName, String customSecondaryName) {
        IAlleleSpecies primary = individual.getGenome().getPrimary();
        IAlleleSpecies secondary = individual.getGenome().getSecondary();
        this.drawLine(text0, this.column0);
        int columnwidth = this.column2 - this.column1 - 16;
        RenderHelper.func_74519_b();
        this.drawItemStack(this.iconStacks.get(primary.getUID()), this.adjustToFactor(this.field_147003_i + this.column1 + columnwidth - 4), this.adjustToFactor(this.field_147009_r + this.getLineY()));
        this.drawItemStack(this.iconStacks.get(secondary.getUID()), this.adjustToFactor(this.field_147003_i + this.column2 + columnwidth - 2), this.adjustToFactor(this.field_147009_r + this.getLineY()));
        RenderHelper.func_74518_a();
        String primaryName = customPrimaryName == null ? primary.getName() : customPrimaryName;
        String secondaryName = customSecondaryName == null ? secondary.getName() : customSecondaryName;
        this.drawSplitLine(primaryName, this.column1, columnwidth, individual, chromosome, false);
        this.drawSplitLine(secondaryName, this.column2, columnwidth, individual, chromosome, true);
        this.newLine();
        this.newLine();
    }

    protected final void drawSpeciesRow(String text0, IIndividual individual, IChromosomeType chromosome) {
        this.drawSpeciesRow(text0, individual, chromosome, null, null);
    }

    protected final String checkCustomName(String key) {
        if (StringUtil.canTranslate(key)) {
            return StringUtil.localize(key);
        }
        return null;
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        this.widgetManager.clear();
    }

    protected void drawAnalyticsOverview() {
        this.startPage();
        this.newLine();
        String title = StringUtil.localize(this.guiName).toUpperCase();
        this.drawCenteredLine(title, 8, 208);
        this.newLine();
        this.field_146289_q.func_78279_b(StringUtil.localize(this.guiName + ".help"), (int)((float)(this.field_147003_i + 12 + 4) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + 42) * (1.0f / this.factor)), (int)(195.0f * (1.0f / this.factor)), this.fontColor.get("gui.screen"));
        this.newLine();
        this.newLine();
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.alyzer.overview") + ":", 16);
        this.newLine();
        this.drawLine("I  : " + StringUtil.localize("gui.general"), 16);
        this.newLine();
        this.drawLine("II : " + StringUtil.localize("gui.environment"), 16);
        this.newLine();
        this.drawLine("III: " + StringUtil.localize("gui.produce"), 16);
        this.newLine();
        this.drawLine("IV : " + StringUtil.localize("gui.evolution"), 16);
        this.newLine();
        String mode = this.breedingTracker.getModeName();
        if (mode != null && !mode.isEmpty()) {
            this.newLine();
            String rules = StringUtil.localize(this.guiName + ".behaviour") + ": " + StringUtil.capitalize(mode);
            this.drawCenteredLine(rules, 8, 208, this.fontColor.get(this.guiName + ".binomial"));
        }
        this.endPage();
    }

    protected final void drawAnalyticsPageClassification(IIndividual individual) {
        this.startPage();
        this.drawLine(StringUtil.localize("gui.alyzer.classification") + ":", 12);
        this.newLine();
        Stack<IClassification> hierarchy = new Stack<IClassification>();
        for (IClassification classification = individual.getGenome().getPrimary().getBranch(); classification != null; classification = classification.getParent()) {
            if (classification.getScientific() == null || classification.getScientific().isEmpty()) continue;
            hierarchy.push(classification);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        IClassification group = null;
        while (!hierarchy.isEmpty()) {
            group = (IClassification)hierarchy.pop();
            if (overcrowded && group.getLevel().isDroppable()) continue;
            this.drawLine(group.getScientific(), x, group.getLevel().getColour());
            this.drawLine(group.getLevel().name(), 155, group.getLevel().getColour());
            this.newLine();
            x += 10;
        }
        String binomial = individual.getGenome().getPrimary().getBinomial();
        if (group != null && group.getLevel() == IClassification.EnumClassLevel.GENUS) {
            binomial = group.getScientific().substring(0, 1) + ". " + binomial.toLowerCase(Locale.ENGLISH);
        }
        this.drawLine(binomial, x, 15445637);
        this.drawLine("SPECIES", 155, 15445637);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.alyzer.authority") + ": " + individual.getGenome().getPrimary().getAuthority(), 12);
        if (AlleleManager.alleleRegistry.isBlacklisted(individual.getIdent())) {
            String extinct = ">> " + StringUtil.localize("gui.alyzer.extinct").toUpperCase() + " <<";
            this.field_146289_q.func_78261_a(extinct, this.adjustToFactor(this.field_147003_i + 208) - this.field_146289_q.func_78256_a(extinct), this.adjustToFactor(this.field_147009_r + this.getLineY()), this.fontColor.get("gui.beealyzer.dominant"));
        }
        this.newLine();
        String description = individual.getGenome().getPrimary().getDescription();
        if (StringUtils.isBlank((CharSequence)description) || description.startsWith("for.description.")) {
            this.drawSplitLine(StringUtil.localize("gui.alyzer.nodescription"), 12, 208, 0x666666);
        } else {
            String[] tokens = description.split("\\|");
            this.drawSplitLine(tokens[0], 12, 208, 0x666666);
            if (tokens.length > 1) {
                this.field_146289_q.func_78261_a("- " + tokens[1], this.adjustToFactor(this.field_147003_i + 208) - this.field_146289_q.func_78256_a("- " + tokens[1]), this.adjustToFactor(this.field_147009_r + 145 - 14), 10079282);
            }
        }
        this.endPage();
    }

    protected void drawAnalyticsPage4(IIndividual individual) {
        float factor = this.factor;
        this.setFactor(1.0f);
        this.startPage(12, 85, 150);
        this.drawLine(StringUtil.localize("gui.beealyzer.mutations") + ":", 12);
        this.newLine();
        RenderHelper.func_74520_c();
        HashMap<IMutation, IAlleleSpecies> combinations = new HashMap<IMutation, IAlleleSpecies>();
        for (IMutation iMutation : this.speciesRoot.getCombinations(individual.getGenome().getPrimary())) {
            combinations.put(iMutation, individual.getGenome().getPrimary());
        }
        for (IMutation iMutation : this.speciesRoot.getCombinations(individual.getGenome().getSecondary())) {
            combinations.put(iMutation, individual.getGenome().getSecondary());
        }
        int columnWidth = 50;
        boolean bl = false;
        for (Map.Entry mutation : combinations.entrySet()) {
            boolean bl2;
            if (this.breedingTracker.isDiscovered((IMutation)mutation.getKey())) {
                this.drawMutationInfo((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), 12 + bl2);
            } else {
                if (((IMutation)mutation.getKey()).isSecret()) continue;
                this.drawUnknownMutation((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), 12 + bl2);
            }
            if ((bl2 += columnWidth) < columnWidth * 4) continue;
            bl2 = false;
            this.newLine();
            this.newLine();
        }
        this.endPage();
        this.setFactor(factor);
    }

    protected void drawMutationInfo(IMutation combination, IAllele species, int x) {
        ItemStack partnerBee = this.iconStacks.get(combination.getPartner(species).getUID());
        this.widgetManager.add(new GuiForestry.ItemStackWidget(this, x, this.getLineY(), partnerBee));
        this.drawProbabilityArrow(combination.getBaseChance(), this.adjustToFactor(this.field_147003_i) + x + 18, this.adjustToFactor(this.field_147009_r) + this.getLineY() + 4);
        IAllele result = combination.getTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        ItemStack resultBee = this.iconStacks.get(result.getUID());
        this.widgetManager.add(new GuiForestry.ItemStackWidget(this, x + 33, this.getLineY(), resultBee));
    }

    protected void drawUnknownMutation(IMutation combination, IAllele species, int x) {
        this.drawQuestionMark(this.adjustToFactor(this.field_147003_i) + x, this.adjustToFactor(this.field_147009_r) + this.getLineY());
        this.drawProbabilityArrow(combination.getBaseChance(), this.adjustToFactor(this.field_147003_i) + x + 18, this.adjustToFactor(this.field_147009_r) + this.getLineY() + 4);
        this.drawQuestionMark(this.adjustToFactor(this.field_147003_i) + x + 32, this.adjustToFactor(this.field_147009_r) + this.getLineY());
    }

    protected void drawQuestionMark(int x, int y) {
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b(x, y, 78, 240, 16, 16);
    }

    protected void drawProbabilityArrow(float chance, int x, int y) {
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
            }
        }
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b(x, y, column, line, 15, 9);
    }

    protected void drawToleranceInfo(IAlleleTolerance toleranceAllele, int x) {
        int textColor = this.getColorCoding(toleranceAllele.isDominant());
        EnumTolerance tolerance = toleranceAllele.getValue();
        String text = "(" + toleranceAllele.getName() + ")";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + (int)(20.0f * this.factor), textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + (int)(20.0f * this.factor), textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + (int)(20.0f * this.factor), textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x, this.getLineY() - 1);
                this.drawLine("(0)", x + (int)(20.0f * this.factor), textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y) {
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b((int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)), 0, 247, 15, 9);
    }

    private void drawUpSymbol(int x, int y) {
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b((int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)), 15, 247, 15, 9);
    }

    private void drawBothSymbol(int x, int y) {
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b((int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)), 30, 247, 15, 9);
    }

    private void drawNoneSymbol(int x, int y) {
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b((int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)), 45, 247, 15, 9);
    }

    protected void drawFertilityInfo(int fertility, int x, int textColor, int texOffset) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b((int)((float)(this.field_147003_i + x + 14) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)), 60, 240 + texOffset, 12, 8);
        this.drawLine(Integer.toString(fertility) + " x", x, textColor);
    }
}

