/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.config.Config;
import forestry.core.config.SessionVars;
import forestry.core.gui.LedgerManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.ForestryResource;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class Ledger {
    protected static final int maxWidth = 124;
    protected static final int minWidth = 24;
    public static final int minHeight = 24;
    protected int maxHeight = 24;
    private static final ResourceLocation ledgerTextureRight = new ForestryResource("textures/gui/ledger.png");
    private static final ResourceLocation ledgerTextureLeft = new ForestryResource("textures/gui/ledgerLeft.png");
    protected final LedgerManager manager;
    protected final int fontColorHeader;
    protected final int fontColorText;
    protected final int fontColorSubheader;
    protected final int overlayColor;
    private boolean open;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected float currentWidth = 24.0f;
    protected float currentHeight = 24.0f;
    protected final ResourceLocation texture;
    private static final float msPerUpdate = 16.667f;
    private long lastUpdateTime = 0L;

    public Ledger(LedgerManager manager, String name) {
        this(manager, name, true);
    }

    public Ledger(LedgerManager manager, String name, boolean rightSide) {
        this.manager = manager;
        this.texture = rightSide ? ledgerTextureRight : ledgerTextureLeft;
        this.fontColorHeader = manager.gui.fontColor.get("ledger." + name + ".header");
        this.fontColorSubheader = manager.gui.fontColor.get("ledger." + name + ".subheader");
        this.fontColorText = manager.gui.fontColor.get("ledger." + name + ".text");
        this.overlayColor = manager.gui.fontColor.get("ledger." + name + ".background");
    }

    public void update() {
        long updateTime;
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = System.currentTimeMillis();
            updateTime = this.lastUpdateTime + (long)Math.round(16.667f);
        } else {
            updateTime = System.currentTimeMillis();
        }
        float moveAmount = (float)((long)Config.guiTabSpeed * (updateTime - this.lastUpdateTime)) / 16.667f;
        this.lastUpdateTime = updateTime;
        if (this.open && this.currentWidth < 124.0f) {
            this.currentWidth += moveAmount;
            if (this.currentWidth > 124.0f) {
                this.currentWidth = 124.0f;
            }
        } else if (!this.open && this.currentWidth > 24.0f) {
            this.currentWidth -= moveAmount;
            if (this.currentWidth < 24.0f) {
                this.currentWidth = 24.0f;
            }
        }
        if (this.open && this.currentHeight < (float)this.maxHeight) {
            this.currentHeight += moveAmount;
            if (this.currentHeight > (float)this.maxHeight) {
                this.currentHeight = this.maxHeight;
            }
        } else if (!this.open && this.currentHeight > 24.0f) {
            this.currentHeight -= moveAmount;
            if (this.currentHeight < 24.0f) {
                this.currentHeight = 24.0f;
            }
        }
    }

    public int getHeight() {
        return Math.round(this.currentHeight);
    }

    public int getWidth() {
        return Math.round(this.currentWidth);
    }

    public abstract void draw(int var1, int var2);

    public abstract String getTooltip();

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return mouseX >= this.currentShiftX && (float)mouseX <= (float)this.currentShiftX + this.currentWidth && mouseY >= this.currentShiftY && mouseY <= this.currentShiftY + this.getHeight();
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = 124.0f;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionVars.setOpenedLedger(null);
        } else {
            this.open = true;
            SessionVars.setOpenedLedger(this.getClass());
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= 124.0f;
    }

    protected void drawBackground(int x, int y) {
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        Proxies.common.bindTexture(this.texture);
        int height = this.getHeight();
        int width = this.getWidth();
        this.manager.gui.func_73729_b(x, y + 4, 0, 256 - height + 4, 4, height - 4);
        this.manager.gui.func_73729_b(x + 4, y, 256 - width + 4, 0, width - 4, 4);
        this.manager.gui.func_73729_b(x, y, 0, 0, 4, 4);
        this.manager.gui.func_73729_b(x + 4, y + 4, 256 - width + 4, 256 - height + 4, width - 4, height - 4);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawIcon(IIcon icon, int x, int y) {
        if (icon != null) {
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Proxies.common.bindTexture(SpriteSheet.ITEMS);
            this.manager.gui.func_94065_a(x, y, icon, 16, 16);
            GL11.glEnable((int)2896);
        }
    }

    protected void drawHeader(String string, int x, int y) {
        this.manager.minecraft.field_71466_p.func_78261_a(string, x, y, this.fontColorHeader);
    }

    protected void drawSubheader(String string, int x, int y) {
        this.manager.minecraft.field_71466_p.func_78261_a(string, x, y, this.fontColorSubheader);
    }

    protected void drawText(String string, int x, int y) {
        this.manager.minecraft.field_71466_p.func_78276_b(string, x, y, this.fontColorText);
    }

    protected void drawSplitText(String string, int x, int y, int width) {
        this.manager.minecraft.field_71466_p.func_78279_b(string, x, y, width, this.fontColorText);
    }
}

