/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.tooltips;

import com.google.common.collect.ForwardingList;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ToolTip
extends ForwardingList<ToolTipLine> {
    private final List<ToolTipLine> delegate = new ArrayList<ToolTipLine>();
    private final long delay;
    private long mouseOverStart;

    public ToolTip() {
        this.delay = 0L;
    }

    public ToolTip(int delay) {
        this.delay = delay;
    }

    protected final List<ToolTipLine> delegate() {
        return this.delegate;
    }

    public boolean add(String line) {
        return this.add(new ToolTipLine(line));
    }

    public boolean add(List lines) {
        boolean changed = false;
        for (Object line : lines) {
            if (!(line instanceof String)) continue;
            changed |= this.add((String)line);
        }
        return changed;
    }

    public void onTick(boolean mouseOver) {
        if (this.delay == 0L) {
            return;
        }
        if (mouseOver) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
    }

    public boolean isReady() {
        if (this.delay == 0L) {
            return true;
        }
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= this.delay;
    }

    public void refresh() {
    }

    public List<String> convertToStrings() {
        ArrayList<String> tips = new ArrayList<String>(this.size());
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            ToolTipLine line = (ToolTipLine)i$.next();
            tips.add(line.toString());
        }
        return tips;
    }

    public static ToolTip buildToolTip(String tipTag, String ... vars) {
        String[] tips;
        ToolTip toolTip = new ToolTip(750);
        String text = StringUtil.localize(tipTag);
        for (String var : vars) {
            String[] pair = var.split("=");
            text = text.replace(pair[0], pair[1]);
        }
        for (String tip : tips = text.split("\n")) {
            tip = tip.trim();
            toolTip.add(new ToolTipLine(tip));
        }
        return toolTip;
    }
}

