/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.gui.ContainerDummy;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeUtil {
    private static final Container DUMMY_CONTAINER = new ContainerDummy();

    public static void injectLeveledRecipe(ItemStack resource, int fermentationValue, Fluids output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output.getFluid(1), Fluids.WATER.getFluid(1));
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.JUICE.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.JUICE.getFluid(1));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.HONEY.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.HONEY.getFluid(1));
        }
    }

    public static List getOreDictRecipeEquivalents(ItemStack itemStack) {
        int[] oreDictIds = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> oreDictNames = new ArrayList<String>(oreDictIds.length);
        for (int oreId : oreDictIds) {
            String oreDictName = OreDictionary.getOreName((int)oreId);
            oreDictNames.add(oreDictName);
        }
        if (oreDictNames.isEmpty()) {
            return Collections.singletonList(itemStack);
        }
        return oreDictNames;
    }

    public static Object[] getCraftingRecipeAsArray(Object rec) {
        try {
            if (rec instanceof IDescriptiveRecipe) {
                IDescriptiveRecipe recipe = (IDescriptiveRecipe)rec;
                return RecipeUtil.getShapedRecipeAsArray(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients(), recipe.func_77571_b());
            }
        }
        catch (Exception ex) {
            Proxies.log.warning("Exception while trying to parse an ItemStack[10] from an IRecipe:");
            Proxies.log.warning(ex.getMessage());
        }
        return null;
    }

    private static Object[] getShapedRecipeAsArray(int width, int height, Object[] ingredients, ItemStack output) {
        Object[] result = new Object[10];
        for (int y = 0; y < height; ++y) {
            System.arraycopy(ingredients, y * width, result, y * 3, width);
        }
        result[9] = output;
        return result;
    }

    public static boolean canCraftRecipe(World world, ItemStack[] recipeItems, ItemStack recipeOutput, ItemStack[] availableItems) {
        if (StackUtils.containsSets(recipeItems, availableItems, true, true) == 0) {
            return false;
        }
        InventoryCrafting crafting = new InventoryCrafting(DUMMY_CONTAINER, 3, 3);
        ItemStack[] stockCopy = StackUtils.condenseStacks(availableItems);
        block0: for (int slot = 0; slot < recipeItems.length; ++slot) {
            ItemStack stack;
            ItemStack recipeStack = recipeItems[slot];
            if (recipeStack == null) continue;
            for (ItemStack stockStack : stockCopy) {
                if (stockStack.field_77994_a <= 0 || !StackUtils.isCraftingEquivalent(recipeStack, stockStack, false, false)) continue;
                stack = StackUtils.createSplitStack(stockStack, 1);
                --stockStack.field_77994_a;
                crafting.func_70299_a(slot, stack);
                break;
            }
            if (crafting.func_70301_a(slot) != null) continue;
            for (ItemStack stockStack : stockCopy) {
                if (stockStack.field_77994_a <= 0 || !StackUtils.isCraftingEquivalent(recipeStack, stockStack, true, true)) continue;
                stack = StackUtils.createSplitStack(stockStack, 1);
                --stockStack.field_77994_a;
                crafting.func_70299_a(slot, stack);
                continue block0;
            }
        }
        ItemStack output = CraftingManager.func_77594_a().func_82787_a(crafting, world);
        return ItemStack.func_77989_b((ItemStack)output, (ItemStack)recipeOutput);
    }
}

