/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import forestry.core.inventory.InvTools;
import forestry.core.proxy.Proxies;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtils {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return StackUtils.stowInInventory(itemstack, inventory, doAdd, 0, inventory.func_70302_i_());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                    itemstack.field_77994_a = 0;
                }
                return true;
            }
            if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space > itemstack.field_77994_a) {
                if (doAdd) {
                    inventoryStack.field_77994_a += itemstack.field_77994_a;
                    itemstack.field_77994_a = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
                itemstack.field_77994_a -= space;
            }
            added = true;
        }
        return added;
    }

    public static int addToInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        int added = 0;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.func_70299_a(i, itemstack.func_77946_l());
                }
                return itemstack.field_77994_a;
            }
            if (inventoryStack.field_77994_a >= inventoryStack.func_77976_d() || !inventoryStack.func_77969_a(itemstack)) continue;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space > itemstack.field_77994_a - added) {
                if (doAdd) {
                    inventoryStack.field_77994_a += itemstack.field_77994_a;
                }
                return itemstack.field_77994_a;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
            }
            added += space;
        }
        return added;
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.field_77994_a >= 64) {
            return;
        }
        if (!receptor.func_77969_a(giver)) {
            return;
        }
        if (giver.field_77994_a <= receptor.func_77976_d() - receptor.field_77994_a) {
            receptor.field_77994_a += giver.field_77994_a;
            giver.field_77994_a = 0;
            return;
        }
        ItemStack temp = giver.func_77979_a(receptor.func_77976_d() - receptor.field_77994_a);
        receptor.field_77994_a += temp.field_77994_a;
        temp.field_77994_a = 0;
    }

    public static boolean freeSpaceInStack(ItemStack stack, int maxSize) {
        if (stack == null) {
            return true;
        }
        return stack.field_77994_a < maxSize;
    }

    public static ItemStack createSplitStack(ItemStack stack, int amount) {
        ItemStack split = new ItemStack(stack.func_77973_b(), amount, stack.func_77960_j());
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)stack.func_77978_p().func_74737_b();
            split.func_77982_d(nbttagcompound);
        }
        return split;
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks) {
        return StackUtils.condenseStacks(stacks, -1, false);
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks, int maxCountedPerStack, boolean craftingEquivalency) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if ((!cached.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)cached, (ItemStack)stack)) && (!craftingEquivalency || !StackUtils.isCraftingEquivalent(cached, stack, true, false))) continue;
                cached.field_77994_a = cached.field_77994_a + (maxCountedPerStack > 0 && stack.field_77994_a > maxCountedPerStack ? maxCountedPerStack : stack.field_77994_a);
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.func_77946_l();
            if (maxCountedPerStack > 0) {
                cached.field_77994_a = maxCountedPerStack;
            }
            condensed.add(cached);
        }
        return condensed.toArray(new ItemStack[condensed.size()]);
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!StackUtils.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock) {
        return StackUtils.containsSets(set, stock, false, false);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock, boolean oreDictionary, boolean craftingTools) {
        int count = 0;
        ItemStack[] condensedRequired = StackUtils.condenseStacks(set, -1, oreDictionary);
        ItemStack[] condensedOffered = StackUtils.condenseStacks(stock, -1, oreDictionary);
        for (ItemStack req : condensedRequired) {
            boolean matched = false;
            for (ItemStack offer : condensedOffered) {
                if (!StackUtils.isCraftingEquivalent(req, offer, oreDictionary, craftingTools)) continue;
                int stackCount = (int)Math.floor(offer.field_77994_a / req.field_77994_a);
                matched |= stackCount > 0;
                if (count == 0) {
                    count = stackCount;
                    continue;
                }
                if (count <= stackCount) continue;
                count = stackCount;
            }
            if (matched) continue;
            return 0;
        }
        return count;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (base.func_77960_j() != Short.MAX_VALUE && base.func_77960_j() != comparison.func_77960_j()) {
            return false;
        }
        if (base.field_77990_d == null || base.field_77990_d.func_82582_d()) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary, boolean craftingTools) {
        if (StackUtils.isCraftingEquivalent(base, comparison)) {
            return true;
        }
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77942_o() && !base.field_77990_d.func_82582_d() && !ItemStack.func_77989_b((ItemStack)base, (ItemStack)comparison)) {
            return false;
        }
        if (oreDictionary) {
            int[] idsBase = OreDictionary.getOreIDs((ItemStack)base);
            Arrays.sort(idsBase);
            int[] idsComp = OreDictionary.getOreIDs((ItemStack)comparison);
            Arrays.sort(idsComp);
            int iBase = 0;
            int iComp = 0;
            while (iBase < idsBase.length && iComp < idsComp.length) {
                if (idsBase[iBase] < idsComp[iComp]) {
                    ++iBase;
                    continue;
                }
                if (idsBase[iBase] > idsComp[iComp]) {
                    ++iComp;
                    continue;
                }
                return true;
            }
        }
        if (craftingTools) {
            return StackUtils.isThisCraftingTool(base, comparison);
        }
        return false;
    }

    public static boolean isCraftingTool(ItemStack itemstack) {
        return itemstack.func_77973_b().hasContainerItem(itemstack) && itemstack.func_77973_b().func_77645_m() && !itemstack.func_77973_b().func_77630_h(itemstack);
    }

    public static boolean isThisCraftingTool(ItemStack phantom, ItemStack actual) {
        return StackUtils.isCraftingTool(phantom) && phantom.func_77973_b() == actual.func_77973_b();
    }

    public static void stowContainerItem(ItemStack itemstack, IInventory stowing, int slotIndex, EntityPlayer player) {
        if (!itemstack.func_77973_b().hasContainerItem(itemstack)) {
            return;
        }
        ItemStack container = itemstack.func_77973_b().getContainerItem(itemstack);
        if (container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) {
            if (player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
            }
            container = null;
        }
        if (container != null) {
            if (itemstack.func_77973_b().func_77630_h(itemstack)) {
                if (!InvTools.tryAddStack(stowing, container, true) && player != null && !player.field_71071_by.func_70441_a(container)) {
                    player.func_71019_a(container, true);
                }
            } else if (!InvTools.tryAddStack(stowing, container, slotIndex, 1, true) && !InvTools.tryAddStack(stowing, container, true) && player != null) {
                player.func_71019_a(container, true);
            }
        }
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        if (items.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = rand.nextInt(max);
        ItemStack created = template.func_77946_l();
        created.field_77994_a = size <= 0 ? 1 : (size > created.func_77976_d() ? created.func_77976_d() : size);
        return created;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == StackUtils.getBlock(stack);
    }

    public static boolean equals(Block block, int meta, ItemStack stack) {
        return block == StackUtils.getBlock(stack) && meta == stack.func_77960_j();
    }

    public static List<ItemStack> parseItemStackStrings(String itemStackStrings, int missingMetaValue) {
        String[] parts = itemStackStrings.split("(\\s*;\\s*)+");
        return StackUtils.parseItemStackStrings(parts, missingMetaValue);
    }

    public static List<ItemStack> parseItemStackStrings(String[] parts, int missingMetaValue) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (String itemStackString : parts) {
            ItemStack itemStack = StackUtils.parseItemStackString(itemStackString, missingMetaValue);
            if (itemStack == null) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    public static ItemStack parseItemStackString(String itemStackString, int missingMetaValue) {
        int meta;
        if ((itemStackString = itemStackString.trim()).isEmpty()) {
            return null;
        }
        String[] parts = itemStackString.split(":+");
        if (parts.length != 2 && parts.length != 3) {
            Proxies.log.warning("ItemStack string (" + itemStackString + ") isn't formatted properly. Suitable formats are <modId>:<name>, <modId>:<name>:<meta> or <modId>:<name>:*, e.g. IC2:blockWall:*");
            return null;
        }
        String name = parts[0] + ':' + parts[1];
        if (parts.length == 2) {
            meta = missingMetaValue;
        } else {
            try {
                meta = parts[2].equals("*") ? Short.MAX_VALUE : NumberFormat.getIntegerInstance().parse(parts[2]).intValue();
            }
            catch (ParseException e) {
                Proxies.log.warning("ItemStack string (" + itemStackString + ") has improperly formatted metadata. Suitable metadata are integer values or *.");
                return null;
            }
        }
        Item item = (Item)GameData.getItemRegistry().getRaw(name);
        if (item == null) {
            Block block = (Block)GameData.getBlockRegistry().getRaw(name);
            if (block != null) {
                item = Item.func_150898_a((Block)block);
            }
            if (item == null) {
                Proxies.log.warning("Failed to find (" + itemStackString + ") in the Forge item and block registries.");
                return null;
            }
        }
        ItemStack itemStack = new ItemStack(item, 1, meta);
        Proxies.log.finer("Parsed (" + itemStackString + ") into: " + itemStack);
        return itemStack;
    }
}

