/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.circuits;

import forestry.core.circuits.Circuit;
import forestry.energy.gadgets.EngineTin;
import net.minecraft.tileentity.TileEntity;

public abstract class CircuitElectricChange
extends Circuit {
    int euChange = 7;
    int rfChange = 20;

    public CircuitElectricChange(String uid, boolean requiresDiscovery) {
        super(uid, requiresDiscovery);
    }

    protected void configureChange(int euChange, int rfChange) {
        this.euChange = euChange;
        this.rfChange = rfChange;
    }

    @Override
    public boolean isCircuitable(TileEntity tile) {
        return tile instanceof EngineTin;
    }

    @Override
    public void onInsertion(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)tile;
        engine.changeEnergyConfig(this.euChange, this.rfChange, 2 * this.euChange);
    }

    @Override
    public void onLoad(int slot, TileEntity tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)tile;
        engine.changeEnergyConfig(-this.euChange, -this.rfChange, -(2 * this.euChange));
    }

    @Override
    public void onTick(int slot, TileEntity tile) {
    }
}

