/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gadgets.Engine;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.Ledger;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.inventory.Container;

public abstract class GuiEngine<C extends Container, I extends Engine>
extends GuiForestryTitled<C, I> {
    public GuiEngine(String texture, C container, I tile) {
        super(texture, container, tile);
    }

    @Override
    protected void initLedgers() {
        super.initLedgers();
        this.ledgerManager.insert(new EngineLedger());
    }

    protected class EngineLedger
    extends Ledger {
        public EngineLedger() {
            super(GuiEngine.this.ledgerManager, "power");
            this.maxHeight = 94;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            this.drawHeader(StringUtil.localize("gui.energy"), x + 22, y + 8);
            this.drawSubheader(StringUtil.localize("gui.currentOutput") + ':', x + 22, y + 20);
            this.drawText(((Engine)GuiEngine.this.inventory).getCurrentOutput() + " RF/t", x + 22, y + 32);
            this.drawSubheader(StringUtil.localize("gui.stored") + ':', x + 22, y + 44);
            this.drawText(((Engine)GuiEngine.this.inventory).getEnergyManager().getEnergyStored(((Engine)GuiEngine.this.inventory).getOrientation()) + " RF", x + 22, y + 56);
            this.drawSubheader(StringUtil.localize("gui.heat") + ':', x + 22, y + 68);
            this.drawText((double)((Engine)GuiEngine.this.inventory).getHeat() / 10.0 + 20.0 + " C", x + 22, y + 80);
        }

        @Override
        public String getTooltip() {
            return ((Engine)GuiEngine.this.inventory).getCurrentOutput() + " RF/t";
        }
    }
}

