/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmHousing;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IPowerHandler;
import forestry.energy.EnergyManager;
import forestry.farming.gadgets.TileFarm;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGearbox
extends TileFarm
implements IPowerHandler {
    public static final int WORK_CYCLES = 4;
    private int activationDelay = 0;
    private int previousDelays = 0;
    private int workCounter;
    private final EnergyManager energyManager = new EnergyManager(200, 50, 10000);

    public TileGearbox() {
        this.fixedType = 4;
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.activationDelay = nbttagcompound.func_74762_e("ActivationDelay");
        this.previousDelays = nbttagcompound.func_74762_e("PrevDelays");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("ActivationDelay", this.activationDelay);
        nbttagcompound.func_74768_a("PrevDelays", this.previousDelays);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        ITileStructure central = this.getCentralTE();
        if (!(central instanceof TileForestry)) {
            return;
        }
        TileForestry centralHousing = (TileForestry)((Object)central);
        boolean hasPower = this.energyManager.getTotalEnergyStored() > 0;
        if (centralHousing.setErrorCondition(!hasPower, EnumErrorCode.NOPOWER)) {
            return;
        }
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.workCounter < 4 && this.energyManager.consumeEnergyToDoWork()) {
            ++this.workCounter;
        }
        if (this.workCounter >= 4 && this.updateOnInterval(5)) {
            if (!(central instanceof IFarmHousing)) {
                return;
            }
            if (((IFarmHousing)((Object)central)).doWork()) {
                this.workCounter = 0;
                this.previousDelays = 0;
            } else {
                this.activationDelay = 10 * this.previousDelays < 120 ? 10 * this.previousDelays : 120;
                ++this.previousDelays;
            }
        }
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }
}

