/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.vect.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicGourd
extends FarmLogic {
    private final IFarmable[] seeds;

    public FarmLogicGourd(IFarmHousing housing) {
        super(housing);
        Collection<IFarmable> farmables = Farmables.farmables.get("farmGourd");
        this.seeds = farmables.toArray(new IFarmable[farmables.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Items.field_151127_ba.func_77617_a(0);
    }

    @Override
    public String getName() {
        return "Gourd Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

