/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGourd
implements IFarmable {
    private final ItemStack seed;
    private final ItemStack stem;
    private final ItemStack fruit;

    public FarmableGourd(ItemStack seed, ItemStack stem, ItemStack fruit) {
        this.seed = seed;
        this.stem = stem;
        this.fruit = fruit;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        return StackUtils.equals(world.func_147439_a(x, y, z), this.stem);
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return null;
        }
        if (!StackUtils.equals(world.func_147439_a(x, y, z), this.fruit)) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.fruit.func_77960_j()) {
            return null;
        }
        return new CropBlock(world, StackUtils.getBlock(this.fruit), this.fruit.func_77960_j(), new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return this.seed.func_77969_a(itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.func_147465_d(x, y, z, StackUtils.getBlock(this.stem), 0, 2);
    }
}

