/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.api.core.ITileStructure;
import forestry.core.fluids.TankManager;
import forestry.core.triggers.Trigger;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;

public class TriggerLowLiquid
extends Trigger {
    private final float threshold;

    public TriggerLowLiquid(String tag, float threshold) {
        super(tag, "lowLiquid");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        TankManager tankManager = ((TileFarmPlain)central).getTankManager();
        FluidTankInfo info = tankManager.getTankInfo(0);
        if (info.fluid == null) {
            return true;
        }
        return (float)info.fluid.amount / (float)info.capacity <= this.threshold;
    }
}

