/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBigMushroom
extends WorldGenerator {
    private final Block mushroom;

    public WorldGenBigMushroom(Block block) {
        this.mushroom = block;
    }

    public WorldGenBigMushroom() {
        this.mushroom = null;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int i;
        Block type = this.mushroom;
        if (type == null) {
            type = random.nextBoolean() ? Blocks.field_150420_aW : Blocks.field_150419_aX;
        }
        int height = random.nextInt(1) + 2;
        boolean flag = true;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int i2 = y; i2 <= y + 1 + height; ++i2) {
            int offset = 3;
            if (i2 == y) {
                offset = 0;
            }
            for (int j = x - offset; j <= x + offset && flag; ++j) {
                for (int k = z - offset; k <= z + offset && flag; ++k) {
                    if (i2 >= 0 && i2 < 256) {
                        Block block = world.func_147439_a(j, i2, k);
                        if (block.isAir((IBlockAccess)world, j, i2, k) || block == Blocks.field_150362_t) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        Block ground = world.func_147439_a(x, y - 1, z);
        if (ground != Blocks.field_150391_bh) {
            return false;
        }
        if (!Blocks.field_150338_P.func_149742_c(world, x, y, z)) {
            return false;
        }
        this.func_150515_a(world, x, y - 1, z, Blocks.field_150346_d);
        int capStartY = y + height;
        if (type == Blocks.field_150419_aX) {
            capStartY = y + height - 1;
        }
        for (i = capStartY; i <= y + height; ++i) {
            int capRad = 1;
            if (type == Blocks.field_150420_aW) {
                capRad = 1;
            }
            for (int j = x - capRad; j <= x + capRad; ++j) {
                for (int k = z - capRad; k <= z + capRad; ++k) {
                    int remain = 5;
                    if (j == x - capRad) {
                        --remain;
                    }
                    if (j == x + capRad) {
                        ++remain;
                    }
                    if (k == z - capRad) {
                        remain -= 3;
                    }
                    if (k == z + capRad) {
                        remain += 3;
                    }
                    if (type == Blocks.field_150420_aW || i < y + height) {
                        if (j == x - (capRad - 1) && k == z - capRad) {
                            remain = 1;
                        }
                        if (j == x - capRad && k == z - (capRad - 1)) {
                            remain = 1;
                        }
                        if (j == x + (capRad - 1) && k == z - capRad) {
                            remain = 3;
                        }
                        if (j == x + capRad && k == z - (capRad - 1)) {
                            remain = 3;
                        }
                        if (j == x - (capRad - 1) && k == z + capRad) {
                            remain = 7;
                        }
                        if (j == x - capRad && k == z + (capRad - 1)) {
                            remain = 7;
                        }
                        if (j == x + (capRad - 1) && k == z + capRad) {
                            remain = 9;
                        }
                        if (j == x + capRad && k == z + (capRad - 1)) {
                            remain = 9;
                        }
                    }
                    if (remain == 5 && i < y + height) {
                        remain = 0;
                    }
                    if (remain == 0 && y < y + height - 1 || world.func_147439_a(j, i, k).func_149662_c()) continue;
                    this.func_150516_a(world, j, i, k, type, remain);
                }
            }
        }
        for (i = 0; i < height; ++i) {
            Block block = world.func_147439_a(x, y + i, z);
            if (block.func_149662_c()) continue;
            this.func_150516_a(world, x, y + i, z, type, 10);
        }
        return true;
    }
}

