/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.core.genetics.Genome;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AlleleTolerance;
import forestry.plugins.PluginLepidopterology;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ButterflyGenome
extends Genome
implements IButterflyGenome {
    public ButterflyGenome(NBTTagCompound nbttagcompound) {
        super(nbttagcompound);
    }

    public ButterflyGenome(IChromosome[] chromosomes) {
        super(chromosomes);
    }

    public static IAlleleButterflySpecies getSpecies(ItemStack itemStack) {
        IAlleleSpecies species = ButterflyGenome.getSpeciesDirectly(itemStack);
        if (species instanceof IAlleleButterflySpecies) {
            return (IAlleleButterflySpecies)species;
        }
        return (IAlleleButterflySpecies)ButterflyGenome.getActiveAllele(itemStack, EnumButterflyChromosome.SPECIES, PluginLepidopterology.butterflyInterface);
    }

    @Override
    public IAlleleButterflySpecies getPrimary() {
        return (IAlleleButterflySpecies)this.getActiveAllele(EnumButterflyChromosome.SPECIES);
    }

    @Override
    public IAlleleButterflySpecies getSecondary() {
        return (IAlleleButterflySpecies)this.getInactiveAllele(EnumButterflyChromosome.SPECIES);
    }

    @Override
    public float getSize() {
        return ((IAlleleFloat)this.getActiveAllele(EnumButterflyChromosome.SIZE)).getValue();
    }

    @Override
    public int getLifespan() {
        return ((IAlleleInteger)this.getActiveAllele(EnumButterflyChromosome.LIFESPAN)).getValue();
    }

    @Override
    public float getSpeed() {
        return ((IAlleleFloat)this.getActiveAllele(EnumButterflyChromosome.SPEED)).getValue();
    }

    @Override
    public int getMetabolism() {
        return ((IAlleleInteger)this.getActiveAllele(EnumButterflyChromosome.METABOLISM)).getValue();
    }

    @Override
    public int getFertility() {
        return ((IAlleleInteger)this.getActiveAllele(EnumButterflyChromosome.FERTILITY)).getValue();
    }

    @Override
    public EnumTolerance getToleranceTemp() {
        return ((AlleleTolerance)this.getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE)).getValue();
    }

    @Override
    public EnumTolerance getToleranceHumid() {
        return ((AlleleTolerance)this.getActiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE)).getValue();
    }

    @Override
    public boolean getNocturnal() {
        return ((AlleleBoolean)this.getActiveAllele(EnumButterflyChromosome.NOCTURNAL)).getValue();
    }

    @Override
    public boolean getTolerantFlyer() {
        return ((AlleleBoolean)this.getActiveAllele(EnumButterflyChromosome.TOLERANT_FLYER)).getValue();
    }

    @Override
    public boolean getFireResist() {
        return ((AlleleBoolean)this.getActiveAllele(EnumButterflyChromosome.FIRE_RESIST)).getValue();
    }

    @Override
    public IFlowerProvider getFlowerProvider() {
        return ((IAlleleFlowers)this.getActiveAllele(EnumButterflyChromosome.FLOWER_PROVIDER)).getProvider();
    }

    @Override
    public IAlleleButterflyEffect getEffect() {
        return (IAlleleButterflyEffect)this.getActiveAllele(EnumButterflyChromosome.EFFECT);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return PluginLepidopterology.butterflyInterface;
    }
}

