/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IPacketHandler;
import forestry.core.network.PacketId;
import forestry.core.network.PacketString;
import forestry.core.proxy.Proxies;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.gadgets.MachineTrader;
import forestry.mail.gui.ContainerCatalogue;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.GuiMailboxInfo;
import forestry.mail.network.PacketLetterInfo;
import forestry.mail.network.PacketPOBoxInfo;
import forestry.mail.network.PacketRequestLetterInfo;
import forestry.mail.network.PacketTraderAddress;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class PacketHandlerMail
implements IPacketHandler {
    @Override
    public boolean onPacketData(PacketId packetID, DataInputStreamForestry data, EntityPlayer player) throws IOException {
        switch (packetID) {
            case LETTER_INFO: {
                PacketLetterInfo packet = new PacketLetterInfo(data);
                PacketHandlerMail.onLetterInfo(packet);
                return true;
            }
            case POBOX_INFO: {
                PacketPOBoxInfo packet = new PacketPOBoxInfo(data);
                PacketHandlerMail.onPOBoxInfo(packet);
                return true;
            }
            case LETTER_REQUEST_INFO: {
                PacketRequestLetterInfo packet = new PacketRequestLetterInfo(data);
                PacketHandlerMail.onLetterRequestInfo(player, packet);
                return true;
            }
            case LETTER_TEXT: {
                PacketString packet = new PacketString(data);
                PacketHandlerMail.onLetterText(player, packet);
                return true;
            }
            case TRADING_ADDRESS_SET: {
                PacketTraderAddress packet = new PacketTraderAddress(data);
                PacketHandlerMail.handleTradeAddressSet(player, packet);
                return true;
            }
            case POBOX_INFO_REQUEST: {
                PacketHandlerMail.onPOBoxInfoRequest(player);
                return true;
            }
        }
        return false;
    }

    private static void onLetterInfo(PacketLetterInfo packet) {
        Container container = Proxies.common.getClientInstance().field_71439_g.field_71070_bA;
        if (container instanceof ContainerLetter) {
            ((ContainerLetter)container).handleLetterInfoUpdate(packet);
        } else if (container instanceof ContainerCatalogue) {
            ((ContainerCatalogue)container).handleTradeInfoUpdate(packet);
        }
    }

    private static void onPOBoxInfo(PacketPOBoxInfo packet) {
        GuiMailboxInfo.instance.setPOBoxInfo(packet.poboxInfo);
    }

    private static void handleTradeAddressSet(EntityPlayer player, PacketTraderAddress packet) {
        TileEntity tile = packet.getTarget(player.field_70170_p);
        if (!(tile instanceof MachineTrader)) {
            return;
        }
        String addressName = packet.getAddressName();
        ((MachineTrader)tile).handleSetAddress(addressName);
    }

    private static void onLetterText(EntityPlayer player, PacketString packet) {
        if (!(player.field_71070_bA instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.field_71070_bA).handleSetText(packet);
    }

    private static void onLetterRequestInfo(EntityPlayer player, PacketRequestLetterInfo packet) {
        if (!(player.field_71070_bA instanceof ContainerLetter)) {
            return;
        }
        ((ContainerLetter)player.field_71070_bA).handleRequestLetterInfo(player, packet);
    }

    private static void onPOBoxInfoRequest(EntityPlayer player) {
        MailAddress address = new MailAddress(player.func_146103_bH());
        POBox pobox = PostRegistry.getOrCreatePOBox(player.field_70170_p, address);
        if (pobox == null) {
            return;
        }
        Proxies.net.sendToPlayer(new PacketPOBoxInfo(PacketId.POBOX_INFO, pobox.getPOBoxInfo()), player);
    }
}

