/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackDefinition
implements IBackpackDefinition {
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final List<String> validItemStacks = new ArrayList<String>();
    private final List<Integer> validOreIds = new ArrayList<Integer>();
    private final List<Class> validItemClasses = new ArrayList<Class>();
    private final List<Class> validBlockClasses = new ArrayList<Class>();
    private final Map<ItemStack, Boolean> isValidItemCache = new ValidItemCache();

    public BackpackDefinition(String name, int primaryColor) {
        this(name, primaryColor, 0xFFFFFF);
    }

    public BackpackDefinition(String name, int primaryColor, int secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.func_77973_b();
        String display = ("" + StatCollector.func_74838_a((String)(item.func_77657_g(backpack) + ".name"))).trim();
        if (backpack.field_77990_d != null && backpack.field_77990_d.func_150297_b("display", 10) && (nbt = backpack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
            display = nbt.func_74779_i("Name");
        }
        return display;
    }

    @Override
    public int getPrimaryColour() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColour() {
        return this.secondaryColor;
    }

    @Override
    public void addValidItem(ItemStack validItem) {
        if (validItem == null) {
            return;
        }
        Item item = validItem.func_77973_b();
        if (item == null) {
            return;
        }
        String itemStackString = item.delegate.name();
        int meta = validItem.func_77960_j();
        if (meta != Short.MAX_VALUE) {
            itemStackString = itemStackString + ':' + meta;
        }
        this.validItemStacks.add(itemStackString);
    }

    public void clearAllValid() {
        this.validItemStacks.clear();
        this.validOreIds.clear();
    }

    @Override
    public void addValidItems(List<ItemStack> validItems) {
        for (ItemStack validItem : validItems) {
            this.addValidItem(validItem);
        }
    }

    public void addValidOreDictName(String oreDictName) {
        int oreId = OreDictionary.getOreID((String)oreDictName);
        this.validOreIds.add(oreId);
    }

    public void addValidOreDictNames(List<String> oreDictNames) {
        for (String oreDictName : oreDictNames) {
            this.addValidOreDictName(oreDictName);
        }
    }

    public void addValidItemClass(Class itemClass) {
        if (itemClass != null) {
            this.validItemClasses.add(itemClass);
        }
    }

    public void addValidItemClasses(List<Class> itemClasses) {
        for (Class itemClass : itemClasses) {
            this.addValidItemClass(itemClass);
        }
    }

    public void addValidBlockClass(Class blockClass) {
        if (blockClass != null) {
            this.validBlockClasses.add(blockClass);
        }
    }

    public void addValidBlockClasses(List<Class> blockClasses) {
        for (Class blockClass : blockClasses) {
            this.addValidBlockClass(blockClass);
        }
    }

    public List<String> getValidItemStacks() {
        return this.validItemStacks;
    }

    public List<Integer> getValidOreIds() {
        return this.validOreIds;
    }

    public List<Class> getValidBlockClasses() {
        return this.validBlockClasses;
    }

    public List<Class> getValidItemClasses() {
        return this.validItemClasses;
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Boolean isValid = this.isValidItemCache.get(itemStack);
        if (isValid != null) {
            return isValid;
        }
        isValid = this.isValidItemUncached(itemStack);
        this.isValidItemCache.put(itemStack, isValid);
        return isValid;
    }

    private boolean isValidItemUncached(ItemStack itemStack) {
        int[] oreIds;
        String itemStackString;
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        String itemStackStringWild = item.delegate.name();
        if (this.validItemStacks.contains(itemStackStringWild)) {
            return true;
        }
        int meta = itemStack.func_77960_j();
        if (meta != Short.MAX_VALUE && this.validItemStacks.contains(itemStackString = itemStackStringWild + ':' + meta)) {
            return true;
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            if (!this.validOreIds.contains(oreId)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        for (Class itemClass : this.validItemClasses) {
            if (!itemClass.isInstance(item)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        Block block = Block.func_149634_a((Item)item);
        if (block != null) {
            for (Class blockClass : this.validBlockClasses) {
                if (!blockClass.isInstance(block)) continue;
                this.validItemStacks.add(itemStackStringWild);
                return true;
            }
        }
        return false;
    }

    private static class ValidItemCache
    extends LinkedHashMap<ItemStack, Boolean> {
        private ValidItemCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ItemStack, Boolean> eldest) {
            return this.size() > 64;
        }
    }
}

