/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import java.util.Locale;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public enum EnumWoodType {
    LARCH,
    TEAK,
    ACACIA,
    LIME,
    CHESTNUT,
    WENGE,
    BAOBAB,
    SEQUOIA(4.0f),
    KAPOK,
    EBONY,
    MAHOGANY,
    BALSA(1.0f),
    WILLOW,
    WALNUT,
    GREENHEART(7.5f),
    CHERRY,
    MAHOE,
    POPLAR,
    PALM,
    PAPAYA,
    PINE(3.0f),
    PLUM,
    MAPLE,
    CITRUS,
    GIGANTEUM,
    IPE,
    PADAUK,
    COCOBOLO,
    ZEBRAWOOD;

    public static final float DEFAULT_HARDNESS = 2.0f;
    public static final EnumWoodType[] VALUES;
    private final float hardness;

    private EnumWoodType() {
        this.hardness = 2.0f;
    }

    private EnumWoodType(float hardness) {
        this.hardness = hardness;
    }

    public float getHardness() {
        return this.hardness;
    }

    @Deprecated
    public void saveToCompound(NBTTagCompound compound) {
        compound.setInteger("WoodType", this.ordinal());
    }

    @Deprecated
    public static EnumWoodType getFromCompound(NBTTagCompound compound) {
        int typeOrdinal;
        if (compound != null && (typeOrdinal = compound.getInteger("WoodType")) >= 0 && typeOrdinal < VALUES.length) {
            return VALUES[typeOrdinal];
        }
        return LARCH;
    }

    public static EnumWoodType getRandom(Random random) {
        return VALUES[random.nextInt(VALUES.length)];
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = EnumWoodType.values();
    }
}

