/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.IFlowerProvider;
import forestry.core.utils.vect.Vect;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class HasFlowersCache
implements INBTTagable {
    private static final String nbtKey = "hasFlowerCache";
    private static final Random random = new Random();
    private static final int flowerCheckInterval = 128;
    private final int flowerCheckTime = random.nextInt(128);
    private ChunkCoordinates flowerCoords = null;
    private int cooldown = 0;

    public boolean hasFlowers(IBee queen, IBeeHousing beeHousing) {
        IFlowerProvider flowerProvider = queen.getGenome().getFlowerProvider();
        String flowerType = flowerProvider.getFlowerType();
        World world = beeHousing.getWorld();
        if (this.flowerCoords != null) {
            Vect max;
            float housingModifier;
            if (world.getTotalWorldTime() % 128L != (long)this.flowerCheckTime) {
                return true;
            }
            IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
            ChunkCoordinates housingCoords = beeHousing.getCoordinates();
            int[] genomeTerritory = queen.getGenome().getTerritory();
            Vect area = new Vect(genomeTerritory).multiply((housingModifier = beeModifier.getTerritoryModifier(queen.getGenome(), 1.0f)) * 3.0f);
            Vect min = new Vect(area).multiply(-0.5f).add(housingCoords);
            if (this.isFlowerValid(world, flowerType, min, max = new Vect(area).multiply(0.5f).add(housingCoords))) {
                return true;
            }
            this.flowerCoords = null;
            this.cooldown = 0;
        }
        if (this.cooldown <= 0) {
            this.flowerCoords = FlowerManager.flowerRegistry.getAcceptedFlowerCoordinates(beeHousing, queen, flowerType);
            this.cooldown = 550;
        } else {
            --this.cooldown;
        }
        return this.flowerCoords != null;
    }

    private boolean isFlowerValid(World world, String flowerType, Vect min, Vect max) {
        if (!HasFlowersCache.isFlowerCoordInRange(this.flowerCoords, min, max)) {
            return false;
        }
        return FlowerManager.flowerRegistry.isAcceptedFlower(flowerType, world, this.flowerCoords.posX, this.flowerCoords.posY, this.flowerCoords.posZ);
    }

    private static boolean isFlowerCoordInRange(ChunkCoordinates flowerCoords, Vect min, Vect max) {
        return flowerCoords.posX >= min.x && flowerCoords.posX <= max.x && flowerCoords.posY >= min.y && flowerCoords.posY <= max.y && flowerCoords.posZ >= min.z && flowerCoords.posZ <= max.z;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.hasKey(nbtKey)) {
            return;
        }
        NBTTagCompound hasFlowerCacheNBT = nbttagcompound.getCompoundTag(nbtKey);
        if (hasFlowerCacheNBT.hasKey("flowerX")) {
            int x = hasFlowerCacheNBT.getInteger("flowerX");
            int y = hasFlowerCacheNBT.getInteger("flowerY");
            int z = hasFlowerCacheNBT.getInteger("flowerZ");
            this.flowerCoords = new ChunkCoordinates(x, y, z);
        }
        this.cooldown = hasFlowerCacheNBT.getInteger("cooldown");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound hasFlowerCacheNBT = new NBTTagCompound();
        if (this.flowerCoords != null) {
            hasFlowerCacheNBT.setInteger("flowerX", this.flowerCoords.posX);
            hasFlowerCacheNBT.setInteger("flowerY", this.flowerCoords.posY);
            hasFlowerCacheNBT.setInteger("flowerZ", this.flowerCoords.posZ);
        }
        hasFlowerCacheNBT.setInteger("cooldown", this.cooldown);
        nbttagcompound.setTag(nbtKey, (NBTBase)hasFlowerCacheNBT);
    }
}

