/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.GrowthRuleDirtGrass;
import forestry.apiculture.flowers.GrowthRuleFertilize;
import forestry.apiculture.flowers.GrowthRuleFlowerPot;
import forestry.apiculture.flowers.GrowthRuleMycelium;
import forestry.apiculture.flowers.GrowthRuleNone;
import forestry.apiculture.flowers.GrowthRuleSnow;
import forestry.core.utils.Log;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public final class FlowerRegistry
implements IFlowerRegistry,
IFlowerGrowthHelper {
    private final Set<String> defaultFlowerTypes = ImmutableSet.of((Object)"flowersVanilla", (Object)"flowersNether", (Object)"flowersCacti", (Object)"flowersMushrooms", (Object)"flowersEnd", (Object)"flowersJungle", (Object[])new String[]{"flowersSnow", "flowersWheat", "flowersGourd"});
    private final HashMultimap<String, IFlowerAcceptableRule> registeredRules = HashMultimap.create();
    private final HashMultimap<String, Block> registeredBlocks = HashMultimap.create();
    private final HashMultimap<String, Flower> registeredFlowers = HashMultimap.create();
    private final ArrayListMultimap<String, IFlowerGrowthRule> growthRules = ArrayListMultimap.create();
    private final Map<String, TreeMap<Double, Flower>> chances = new HashMap<String, TreeMap<Double, Flower>>();

    public FlowerRegistry() {
        this.registerVanillaGrowthRules();
    }

    @Override
    public void registerAcceptableFlower(Block block, String ... flowerTypes) {
        this.registerFlower(block, Short.MAX_VALUE, 0.0, flowerTypes);
    }

    @Override
    public void registerAcceptableFlower(Block block, int meta, String ... flowerTypes) {
        this.registerFlower(block, meta, 0.0, flowerTypes);
    }

    @Override
    public void registerAcceptableFlowerRule(IFlowerAcceptableRule acceptableFlower, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (this.defaultFlowerTypes.contains(flowerType)) {
                Log.severe("IFlowerAcceptableRules are too slow to be applied to Forestry's built-in flower type: " + flowerType + ".");
                continue;
            }
            this.registeredRules.put((Object)flowerType, (Object)acceptableFlower);
        }
    }

    @Override
    public void registerPlantableFlower(Block block, int meta, double weight, String ... flowerTypes) {
        this.registerFlower(block, meta, weight, flowerTypes);
    }

    private void registerFlower(Block block, int meta, double weight, String ... flowerTypes) {
        if (block == null) {
            return;
        }
        if (weight <= 0.0) {
            weight = 0.0;
        }
        if (weight >= 1.0) {
            weight = 1.0;
        }
        Flower newFlower = new Flower(block, meta, weight);
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + block);
            }
            Set flowers = this.registeredFlowers.get((Object)flowerType);
            flowers.add(newFlower);
            Set blocks = this.registeredBlocks.get((Object)flowerType);
            blocks.add(block);
            if (!this.chances.containsKey(flowerType)) continue;
            this.chances.remove(flowerType);
        }
    }

    private static Vect getArea(IBeeGenome genome, IBeeModifier beeModifier) {
        int[] genomeTerritory = genome.getTerritory();
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return new Vect(genomeTerritory).multiply(housingModifier * 3.0f);
    }

    @Override
    public ChunkCoordinates getAcceptedFlowerCoordinates(IBeeHousing beeHousing, IBee bee, String flowerType) {
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return null;
        }
        Set acceptableRules = this.registeredRules.get((Object)flowerType);
        Set acceptedBlocks = this.registeredBlocks.get((Object)flowerType);
        Set acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        World world = beeHousing.getWorld();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
        Vect area = FlowerRegistry.getArea(bee.getGenome(), beeModifier);
        Vect housingPos = new Vect(beeHousing.getCoordinates()).add(-area.x / 2, -area.y / 2, -area.z / 2);
        MutableVect posCurrent = new MutableVect(0, 0, 0);
        while (posCurrent.advancePositionInArea(area)) {
            Vect posBlock = Vect.add(housingPos, posCurrent);
            for (IFlowerAcceptableRule acceptableRule : acceptableRules) {
                if (!acceptableRule.isAcceptableFlower(flowerType, world, posBlock.x, posBlock.y, posBlock.z)) continue;
                return new ChunkCoordinates(posBlock.x, posBlock.y, posBlock.z);
            }
            if (!FlowerRegistry.isAcceptedFlower(flowerType, acceptedBlocks, acceptedFlowers, world, posBlock.x, posBlock.y, posBlock.z)) continue;
            return new ChunkCoordinates(posBlock.x, posBlock.y, posBlock.z);
        }
        return null;
    }

    @Override
    public boolean isAcceptedFlower(String flowerType, World world, int x, int y, int z) {
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return false;
        }
        Set acceptedCustom = this.registeredRules.get((Object)flowerType);
        for (IFlowerAcceptableRule acceptableFlower : acceptedCustom) {
            if (!acceptableFlower.isAcceptableFlower(flowerType, world, x, y, z)) continue;
            return true;
        }
        Set acceptedBlocks = this.registeredBlocks.get((Object)flowerType);
        Set acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        return FlowerRegistry.isAcceptedFlower(flowerType, acceptedBlocks, acceptedFlowers, world, x, y, z);
    }

    private static boolean isAcceptedFlower(String flowerType, Set<Block> acceptedBlocks, Set<Flower> acceptedFlowers, World world, int x, int y, int z) {
        Block cropBlock;
        int meta;
        Block block = world.getBlock(x, y, z);
        if (block instanceof BlockFlowerPot) {
            TileEntity tile = world.getTileEntity(x, y, z);
            TileEntityFlowerPot tileFlowerPot = (TileEntityFlowerPot)tile;
            Item item = tileFlowerPot.getFlowerPotItem();
            block = Block.getBlockFromItem((Item)item);
            meta = tileFlowerPot.getFlowerPotData();
        } else {
            if (!acceptedBlocks.contains(block)) {
                return false;
            }
            meta = world.getBlockMetadata(x, y, z);
        }
        if (PluginManager.Module.AGRICRAFT.isEnabled() && block == (cropBlock = GameRegistry.findBlock((String)"AgriCraft", (String)"crops"))) {
            if (block instanceof IPlantable) {
                block = ((IPlantable)block).getPlant((IBlockAccess)world, x, y, z);
            } else {
                ArrayList drops = block.getDrops(world, x, y, z, 7, 0);
                if (((ItemStack)drops.get(1)).getItem() == Items.wheat_seeds && flowerType.equals("flowersWheat")) {
                    return true;
                }
                if (((ItemStack)drops.get(1)).getItem() == Items.nether_wart && flowerType.equals("flowersNether")) {
                    return true;
                }
            }
        }
        Flower flower = new Flower(block, meta, 0.0);
        return acceptedFlowers.contains(flower);
    }

    @Override
    public boolean growFlower(String flowerType, World world, IIndividual individual, int x, int y, int z) {
        if (!this.growthRules.containsKey((Object)flowerType)) {
            return false;
        }
        for (IFlowerGrowthRule rule : this.growthRules.get((Object)flowerType)) {
            boolean success;
            try {
                success = rule.growFlower(this, flowerType, world, x, y, z);
            }
            catch (Throwable ignored) {
                success = rule.growFlower(this, flowerType, world, individual, x, y, z);
            }
            if (!success) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IFlower> getAcceptableFlowers(String flowerType) {
        return ImmutableSet.copyOf((Collection)this.registeredFlowers.get((Object)flowerType));
    }

    @Override
    public void registerGrowthRule(IFlowerGrowthRule rule, String ... flowerTypes) {
        if (rule == null) {
            return;
        }
        for (String flowerType : flowerTypes) {
            this.growthRules.get((Object)flowerType).add(rule);
        }
    }

    @Override
    public IFlower getRandomPlantableFlower(String flowerType, Random rand) {
        TreeMap<Double, Flower> chancesMap = this.getChancesMap(flowerType);
        double maxKey = chancesMap.lastKey() + 1.0;
        return chancesMap.get(chancesMap.lowerKey(rand.nextDouble() * maxKey));
    }

    @Override
    public Collection<String> getFlowerTypes() {
        return new ArrayList<String>((Collection<String>)Sets.union(this.defaultFlowerTypes, (Set)this.registeredFlowers.keySet()));
    }

    private TreeMap<Double, Flower> getChancesMap(String flowerType) {
        if (!this.chances.containsKey(flowerType)) {
            TreeMap<Double, Flower> flowerChances = new TreeMap<Double, Flower>();
            double count = 0.0;
            for (Flower flower : this.registeredFlowers.get((Object)flowerType)) {
                if (!flower.isPlantable()) continue;
                flowerChances.put(count, flower);
                count += flower.getWeight();
            }
            this.chances.put(flowerType, flowerChances);
        }
        return this.chances.get(flowerType);
    }

    private void registerVanillaGrowthRules() {
        this.registerGrowthRule(new GrowthRuleDirtGrass(), "flowersVanilla", "flowersSnow");
        this.registerGrowthRule(new GrowthRuleSnow(), "flowersSnow");
        this.registerGrowthRule(new GrowthRuleFlowerPot(), "flowersVanilla", "flowersSnow", "flowersMushrooms", "flowersCacti", "flowersJungle");
        this.registerGrowthRule(new GrowthRuleMycelium(), "flowersMushrooms");
        this.registerGrowthRule(new GrowthRuleNone(), "flowersEnd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.melon_stem, Blocks.pumpkin_stem), "flowersGourd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.wheat), "flowersWheat");
    }

    @Override
    public boolean plantRandomFlower(String flowerType, World world, int x, int y, int z) {
        IFlower flower = this.getRandomPlantableFlower(flowerType, world.rand);
        return world.setBlock(x, y, z, flower.getBlock(), flower.getMeta(), 2);
    }
}

