/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class GrowthRuleFertilize
implements IFlowerGrowthRule {
    private final List<Block> allowedItems;

    public GrowthRuleFertilize(Block ... allowedItems) {
        this.allowedItems = Arrays.asList(allowedItems);
    }

    @Override
    public boolean growFlower(IFlowerRegistry fr, String flowerType, World world, IIndividual individual, int x, int y, int z) {
        return this.growFlower(world, x, y, z);
    }

    @Override
    public boolean growFlower(IFlowerGrowthHelper helper, String flowerType, World world, int x, int y, int z) {
        return this.growFlower(world, x, y, z);
    }

    private boolean growFlower(World world, int x, int y, int z) {
        Block ground = world.getBlock(x, y, z);
        for (Block b : this.allowedItems) {
            if (b != ground) continue;
            int groundMeta = world.getBlockMetadata(x, y, z);
            if (groundMeta > 6) {
                return false;
            }
            groundMeta = groundMeta < 6 ? (groundMeta += world.rand.nextInt(2) + 1) : 7;
            return world.setBlockMetadataWithNotify(x, y, z, groundMeta, 2);
        }
        return false;
    }
}

