/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.world.World;

public class GrowthRuleFlowerPot
implements IFlowerGrowthRule {
    @Override
    public boolean growFlower(IFlowerRegistry fr, String flowerType, World world, IIndividual individual, int x, int y, int z) {
        return GrowthRuleFlowerPot.growFlower(flowerType, world, x, y, z);
    }

    @Override
    public boolean growFlower(IFlowerGrowthHelper helper, String flowerType, World world, int x, int y, int z) {
        return GrowthRuleFlowerPot.growFlower(flowerType, world, x, y, z);
    }

    private static boolean growFlower(String flowerType, World world, int x, int y, int z) {
        int flower;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileEntityFlowerPot)) {
            return false;
        }
        TileEntityFlowerPot flowerPotTile = (TileEntityFlowerPot)tile;
        if (flowerPotTile.getFlowerPotItem() != null) {
            return false;
        }
        Block block = world.getBlock(x, y, z);
        if (!(block instanceof BlockFlowerPot)) {
            return false;
        }
        BlockFlowerPot flowerPot = (BlockFlowerPot)block;
        switch (flowerType) {
            case "flowersVanilla": 
            case "flowersSnow": {
                flower = world.rand.nextInt(2) + 1;
                break;
            }
            case "flowersJungle": {
                flower = 6;
                break;
            }
            case "flowersCacti": {
                flower = world.rand.nextInt(2) + 9;
                break;
            }
            case "flowersMushrooms": {
                flower = world.rand.nextInt(2) + 7;
                break;
            }
            default: {
                return false;
            }
        }
        TileEntityFlowerPot newTile = (TileEntityFlowerPot)flowerPot.createNewTileEntity(world, flower);
        flowerPotTile.func_145964_a(newTile.getFlowerPotItem(), newTile.getFlowerPotData());
        flowerPotTile.markDirty();
        if (!world.setBlockMetadataWithNotify(x, y, z, 1, 2)) {
            world.markBlockForUpdate(x, y, z);
        }
        return true;
    }
}

