/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.BreedingTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ApiaristTracker
extends BreedingTracker
implements IApiaristTracker {
    private int queensTotal = 0;
    private int dronesTotal = 0;
    private int princessesTotal = 0;

    public ApiaristTracker(String s) {
        super(s);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.queensTotal = nbttagcompound.getInteger("QueensTotal");
        this.princessesTotal = nbttagcompound.getInteger("PrincessesTotal");
        this.dronesTotal = nbttagcompound.getInteger("DronesTotal");
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("QueensTotal", this.queensTotal);
        nbttagcompound.setInteger("PrincessesTotal", this.princessesTotal);
        nbttagcompound.setInteger("DronesTotal", this.dronesTotal);
        super.writeToNBT(nbttagcompound);
    }

    @Override
    public void registerPickup(IIndividual individual) {
        ISpeciesRoot speciesRoot = individual.getGenome().getPrimary().getRoot();
        if (!speciesRoot.getUID().equals(this.speciesRootUID())) {
            return;
        }
        if (!individual.isPureBred(EnumBeeChromosome.SPECIES)) {
            return;
        }
        if (speciesRoot.getCombinations(individual.getGenome().getPrimary()).size() > 0) {
            return;
        }
        this.registerSpecies(individual.getGenome().getPrimary());
    }

    @Override
    public void registerQueen(IIndividual bee) {
        ++this.queensTotal;
    }

    @Override
    public int getQueenCount() {
        return this.queensTotal;
    }

    @Override
    public void registerPrincess(IIndividual bee) {
        ++this.princessesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getPrincessCount() {
        return this.princessesTotal;
    }

    @Override
    public void registerDrone(IIndividual bee) {
        ++this.dronesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getDroneCount() {
        return this.dronesTotal;
    }

    @Override
    protected IBreedingTracker getBreedingTracker(EntityPlayer player) {
        return BeeManager.beeRoot.getBreedingTracker(player.worldObj, player.getGameProfile());
    }

    @Override
    protected String speciesRootUID() {
        return "rootBees";
    }
}

