/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import cpw.mods.fml.relauncher.ReflectionHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class AlleleEffectPotion
extends AlleleEffectThrottled {
    private final Potion potion;
    private final int potionFXColor;
    private final boolean isBadEffect;
    private final int duration;
    private final float chance;

    public AlleleEffectPotion(String name, boolean isDominant, Potion potion, int duration, int throttle, float chance) {
        super(name, isDominant, throttle, true, false);
        this.potion = potion;
        this.isBadEffect = AlleleEffectPotion.isBadEffect(potion);
        this.duration = duration;
        this.chance = chance;
        Set<PotionEffect> potionEffects = Collections.singleton(new PotionEffect(potion.getId(), 1, 0));
        this.potionFXColor = PotionHelper.calcPotionLiquidColor(potionEffects);
    }

    public AlleleEffectPotion(String name, boolean isDominant, Potion potion, int duration) {
        this(name, isDominant, potion, duration, 200, 1.0f);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        List<EntityLivingBase> entities = AlleleEffectPotion.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            if (world.rand.nextFloat() >= this.chance) continue;
            int dur = this.duration;
            if (this.isBadEffect) {
                int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
                if (count >= 4) continue;
                if (count == 3) {
                    dur = this.duration / 4;
                } else if (count == 2) {
                    dur = this.duration / 2;
                } else if (count == 1) {
                    dur = this.duration * 3 / 4;
                }
            } else if (entity instanceof IMob) continue;
            entity.addPotionEffect(new PotionEffect(this.potion.getId(), dur, 0));
        }
        return storedData;
    }

    private static boolean isBadEffect(Potion potion) {
        try {
            return (Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)potion, (String[])new String[]{"field_76418_K", "isBadEffect"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            Log.severe("Could not access potion field isBadEffect.");
            return false;
        }
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (housing.getWorld().rand.nextBoolean()) {
            super.doFX(genome, storedData, housing);
        } else {
            Vec3 beeFXCoordinates = this.getFXCoordinates(housing);
            Proxies.render.addEntityPotionFX(housing.getWorld(), beeFXCoordinates.xCoord, beeFXCoordinates.yCoord + 0.5, beeFXCoordinates.zCoord, this.potionFXColor);
        }
        return storedData;
    }
}

