/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.core.Tabs;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.config.Config;
import forestry.core.items.ItemForestryMultiPass;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemHoneycomb
extends ItemForestryMultiPass {
    public ItemHoneycomb() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(Tabs.tabApiculture);
    }

    public boolean isDamageable() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public String getUnlocalizedName(ItemStack stack) {
        EnumHoneyComb honeyComb = EnumHoneyComb.VALUES[stack.getItemDamage()];
        return super.getUnlocalizedName(stack) + "." + honeyComb.name;
    }

    public int getColorFromItemStack(ItemStack itemstack, int j) {
        EnumHoneyComb honeyComb = EnumHoneyComb.VALUES[itemstack.getItemDamage()];
        if (j == 0) {
            return honeyComb.primaryColor;
        }
        return honeyComb.secondaryColor;
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < EnumHoneyComb.VALUES.length; ++i) {
            EnumHoneyComb honeyComb = EnumHoneyComb.VALUES[i];
            if (honeyComb.isSecret() && !Config.isDebug) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    private static EnumHoneyComb getRandomCombType(Random random, boolean includeSecret) {
        ArrayList<EnumHoneyComb> validCombs = new ArrayList<EnumHoneyComb>(EnumHoneyComb.VALUES.length);
        for (int i = 0; i < EnumHoneyComb.VALUES.length; ++i) {
            EnumHoneyComb honeyComb = EnumHoneyComb.VALUES[i];
            if (honeyComb.isSecret() && !includeSecret) continue;
            validCombs.add(honeyComb);
        }
        if (validCombs.isEmpty()) {
            return null;
        }
        return (EnumHoneyComb)((Object)validCombs.get(random.nextInt(validCombs.size())));
    }

    public ItemStack getRandomComb(int amount, Random random, boolean includeSecret) {
        EnumHoneyComb honeyComb = ItemHoneycomb.getRandomCombType(random, includeSecret);
        return this.get(honeyComb, amount);
    }

    public ItemStack get(EnumHoneyComb honeyComb, int amount) {
        return new ItemStack((Item)this, amount, honeyComb.ordinal());
    }
}

