/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import forestry.api.apiculture.EnumBeeType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class ModelBee
extends ModelBase {
    private final ModelRenderer snout;
    private final ModelRenderer torsoWing;
    private final ModelRenderer rump;
    private final ModelRenderer tail;
    private final ModelRenderer tailEnd;
    private final ModelRenderer bridge;
    private final ModelRenderer eyeRight;
    private final ModelRenderer eyeLeft;
    private final ModelRenderer wingLeft;
    private final ModelRenderer wingRight;
    private final ModelRenderer crownQueen;
    private final ModelRenderer crownPrincess;
    private EnumBeeType type = EnumBeeType.DRONE;

    public ModelBee() {
        this.textureWidth = 64;
        this.textureHeight = 32;
        this.snout = new ModelRenderer((ModelBase)this, 18, 11);
        this.snout.addBox(0.0f, 0.0f, 0.0f, 1, 2, 1);
        this.snout.setRotationPoint(0.0f, 1.0f, -2.0f);
        this.snout.setTextureSize(64, 32);
        this.snout.mirror = true;
        ModelBee.setRotation(this.snout, 0.0f, 0.0f, 0.0f);
        this.torsoWing = new ModelRenderer((ModelBase)this, 28, 14);
        this.torsoWing.addBox(0.0f, 0.0f, 0.0f, 3, 3, 1);
        this.torsoWing.setRotationPoint(-1.0f, 0.0f, -1.0f);
        this.torsoWing.setTextureSize(64, 32);
        this.torsoWing.mirror = true;
        ModelBee.setRotation(this.torsoWing, 0.0f, 0.0f, 0.0f);
        this.rump = new ModelRenderer((ModelBase)this, 10, 14);
        this.rump.addBox(-1.0f, -1.0f, 0.0f, 3, 3, 3);
        this.rump.setRotationPoint(0.0f, 1.0f, 1.0f);
        this.rump.setTextureSize(64, 32);
        this.rump.mirror = true;
        ModelBee.setRotation(this.rump, 0.0f, 0.0f, 0.0f);
        this.tail = new ModelRenderer((ModelBase)this, 4, 14);
        this.tail.addBox(0.0f, 0.0f, 0.0f, 2, 2, 1);
        this.tail.setRotationPoint(-0.5f, 0.5333334f, 4.0f);
        this.tail.setTextureSize(64, 32);
        this.tail.mirror = true;
        ModelBee.setRotation(this.tail, 0.0f, 0.0f, 0.0f);
        this.tailEnd = new ModelRenderer((ModelBase)this, 0, 14);
        this.tailEnd.addBox(0.0f, 0.0f, 0.0f, 1, 1, 1);
        this.tailEnd.setRotationPoint(0.0f, 1.0f, 5.0f);
        this.tailEnd.setTextureSize(64, 32);
        this.tailEnd.mirror = true;
        ModelBee.setRotation(this.tailEnd, 0.0f, 0.0f, 0.0f);
        this.bridge = new ModelRenderer((ModelBase)this, 22, 14);
        this.bridge.addBox(0.0f, 0.0f, 0.0f, 2, 2, 1);
        this.bridge.setRotationPoint(-0.5f, 0.5f, 0.0f);
        this.bridge.setTextureSize(64, 32);
        this.bridge.mirror = true;
        ModelBee.setRotation(this.bridge, 0.0f, 0.0f, 0.0f);
        this.eyeRight = new ModelRenderer((ModelBase)this, 22, 9);
        this.eyeRight.addBox(0.0f, 0.0f, 0.0f, 1, 1, 1);
        this.eyeRight.setRotationPoint(-1.0f, 0.0f, -2.0f);
        this.eyeRight.setTextureSize(64, 32);
        this.eyeRight.mirror = true;
        ModelBee.setRotation(this.eyeRight, 0.0f, 0.0f, 0.0f);
        this.eyeLeft = new ModelRenderer((ModelBase)this, 18, 9);
        this.eyeLeft.addBox(0.0f, 0.0f, 0.0f, 1, 1, 1);
        this.eyeLeft.setRotationPoint(1.0f, 0.0f, -2.0f);
        this.eyeLeft.setTextureSize(64, 32);
        this.eyeLeft.mirror = true;
        ModelBee.setRotation(this.eyeLeft, 0.0f, 0.0f, 0.0f);
        this.wingLeft = new ModelRenderer((ModelBase)this, 0, 0);
        this.wingLeft.addBox(0.0f, 0.0f, 0.0f, 3, 1, 6);
        this.wingLeft.setRotationPoint(1.0f, -0.1f, -0.5f);
        this.wingLeft.setTextureSize(64, 32);
        this.wingLeft.mirror = true;
        ModelBee.setRotation(this.wingLeft, 0.0f, 0.1396263f, 0.0f);
        this.wingRight = new ModelRenderer((ModelBase)this, 0, 7);
        this.wingRight.addBox(-3.0f, 0.0f, 0.0f, 3, 1, 6);
        this.wingRight.setRotationPoint(0.0f, -0.1f, -0.5f);
        this.wingRight.setTextureSize(64, 32);
        this.wingRight.mirror = true;
        ModelBee.setRotation(this.wingRight, 0.0f, -0.1396263f, 0.0f);
        this.crownQueen = new ModelRenderer((ModelBase)this, 0, 17);
        this.crownQueen.addBox(0.0f, 0.0f, 0.0f, 2, 1, 2);
        this.crownQueen.setRotationPoint(-0.5f, -1.5f, -1.5f);
        this.crownQueen.setTextureSize(64, 32);
        this.crownQueen.mirror = true;
        ModelBee.setRotation(this.crownQueen, 0.0f, 0.0f, 0.0f);
        this.crownPrincess = new ModelRenderer((ModelBase)this, 0, 20);
        this.crownPrincess.addBox(0.0f, 0.0f, 0.0f, 2, 1, 2);
        this.crownPrincess.setRotationPoint(-0.5f, -1.5f, -1.5f);
        this.crownPrincess.setTextureSize(64, 32);
        this.crownPrincess.mirror = true;
        ModelBee.setRotation(this.crownPrincess, 0.0f, 0.0f, 0.0f);
    }

    public void setType(EnumBeeType type) {
        this.type = type;
    }

    public void render(Entity entity, float f, float f1, float swing, float f3, float f4, float f5) {
        super.render(entity, f, f1, swing, f3, f4, f5);
        this.wingRight.rotateAngleZ = MathHelper.cos((float)(swing * 1.3f)) * (float)Math.PI * 0.25f;
        this.wingLeft.rotateAngleZ = -this.wingRight.rotateAngleZ;
        GL11.glPushMatrix();
        float scale = 0.75f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)0.0f, (float)(12.0f / scale * f5), (float)0.0f);
        this.snout.render(f5);
        this.torsoWing.render(f5);
        this.rump.render(f5);
        this.tail.render(f5);
        this.tailEnd.render(f5);
        this.bridge.render(f5);
        this.eyeRight.render(f5);
        this.eyeLeft.render(f5);
        this.wingLeft.render(f5);
        this.wingRight.render(f5);
        if (this.type == EnumBeeType.PRINCESS) {
            this.crownPrincess.render(f5);
        } else if (this.type == EnumBeeType.QUEEN) {
            this.crownQueen.render(f5);
        }
        GL11.glPopMatrix();
    }

    private static void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    }
}

