/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenMahoe
extends WorldGenTree {
    public WorldGenMahoe(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        ArrayList<ChunkCoordinates> branchCoords = new ArrayList<ChunkCoordinates>();
        for (int yBranch = 2; yBranch < this.height - 1; ++yBranch) {
            branchCoords.addAll(this.generateBranches(world, yBranch, 0, 0, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.75f), 1, 0.25f));
        }
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, 2.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        this.generateSphere(world, this.getCenteredAt(yCenter, 0, 0), 3 + world.rand.nextInt(this.girth), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }
}

