/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenWalnut
extends WorldGenTree {
    public WorldGenWalnut(ITreeGenData tree) {
        super(tree, 7, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        float branchSize = 2.0f;
        while (leafSpawn >= 3) {
            int leafRadius = Math.min(4, (int)branchSize);
            List<ChunkCoordinates> branchCoords = this.generateBranches(world, leafSpawn, 0, 0, 0.2f, 0.2f, (int)branchSize, 1, 0.5f);
            for (ChunkCoordinates branchEnd : branchCoords) {
                this.generateAdjustedCircle(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, leafRadius, 2, 2, this.leaf, 1.0f, WorldGenBase.EnumReplaceMode.SOFT);
            }
            --leafSpawn;
            branchSize += 0.25f;
        }
    }
}

