/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IClimateProvider;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class DefaultClimateProvider
implements IClimateProvider {
    private World world;
    private int xCoord;
    private int yCoord;
    private int zCoord;

    public DefaultClimateProvider(World world, int x, int y, int z) {
        this.world = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.world.getBiomeGenForCoords(this.xCoord, this.zCoord);
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(ForestryAPI.climateManager.getHumidity(this.world, this.xCoord, this.yCoord, this.zCoord));
    }
}

