/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.CommandHelpers;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.SubCommand;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class CommandModeInfo
extends SubCommand {
    private final String[] modeStringArr;
    private final String helpString;
    private final ICommandModeHelper modeHelper;

    public CommandModeInfo(ICommandModeHelper modeHelper) {
        super("info");
        this.modeHelper = modeHelper;
        this.modeStringArr = modeHelper.getModeNames();
        this.helpString = StringUtils.join((Object[])this.modeStringArr, (String)", ");
    }

    @Override
    public void processSubCommand(ICommandSender sender, String[] args) {
        if (args.length <= 0) {
            this.printHelp(sender);
            return;
        }
        String modeName = this.modeHelper.getModeNameMatching(args[0]);
        if (modeName == null) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.info.error", args[0]);
            this.printHelp(sender);
            return;
        }
        ChatStyle green = new ChatStyle();
        green.setColor(EnumChatFormatting.GREEN);
        CommandHelpers.sendLocalizedChatMessage(sender, green, modeName, new Object[0]);
        for (String desc : this.modeHelper.getDescription(modeName)) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for." + desc, new Object[0]);
        }
    }

    @Override
    public void printHelp(ICommandSender sender) {
        super.printHelp(sender);
        World world = CommandHelpers.getWorld(sender, this);
        String modeName = this.modeHelper.getModeName(world);
        String worldName = String.valueOf(world.getWorldInfo().getSaveVersion());
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.info.current", modeName, worldName);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.info.available", this.helpString);
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] incomplete) {
        return CommandHelpers.getListOfStringsMatchingLastWord(incomplete, this.modeStringArr);
    }
}

