/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gui.slots.SlotWatched;
import forestry.core.render.TextureManager;
import forestry.core.tiles.IFilterSlotDelegate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class SlotFiltered
extends SlotWatched {
    private String blockedTexture = "slots/blocked";
    private final IFilterSlotDelegate filterSlotDelegate;

    public <T extends IInventory & IFilterSlotDelegate> SlotFiltered(T inventory, int slotIndex, int xPos, int yPos) {
        super(inventory, slotIndex, xPos, yPos);
        this.filterSlotDelegate = inventory;
    }

    public boolean isItemValid(ItemStack itemstack) {
        int slotIndex = this.getSlotIndex();
        if (this.filterSlotDelegate.isLocked(slotIndex)) {
            return false;
        }
        if (itemstack != null) {
            return this.filterSlotDelegate.canSlotAccept(slotIndex, itemstack);
        }
        return true;
    }

    public SlotFiltered setBlockedTexture(String ident) {
        this.blockedTexture = ident;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBackgroundIconIndex() {
        ItemStack stack = this.getStack();
        if (!this.isItemValid(stack)) {
            return TextureManager.getInstance().getDefault(this.blockedTexture);
        }
        return null;
    }
}

