/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.TileEscritoire;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SlotUtil;
import net.minecraft.item.ItemStack;

public class InventoryEscritoire
extends InventoryAdapterTile<TileEscritoire> {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_RESULTS_1 = 1;
    public static final short SLOTS_RESULTS_COUNT = 6;
    public static final short SLOT_INPUT_1 = 7;
    public static final short SLOTS_INPUT_COUNT = 5;

    public InventoryEscritoire(TileEscritoire escritoire) {
        super(escritoire, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 7 && slotIndex < 7 + ((TileEscritoire)this.tile).getGame().getSampleSize(5)) {
            ItemStack specimen = this.getStackInSlot(0);
            if (specimen == null) {
                return false;
            }
            IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
            return individual != null && individual.getGenome().getPrimary().getResearchSuitability(itemStack) > 0.0f;
        }
        if (slotIndex == 0) {
            return AlleleManager.alleleRegistry.isIndividual(itemStack);
        }
        return false;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        if (slotIndex == 0) {
            return false;
        }
        if (this.getStackInSlot(0) == null) {
            return true;
        }
        return SlotUtil.isSlotInRange(slotIndex, 7, 5) && slotIndex >= 7 + ((TileEscritoire)this.tile).getGame().getSampleSize(5);
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
        return SlotUtil.isSlotInRange(slotIndex, 1, 6);
    }

    @Override
    public void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        super.setInventorySlotContents(slotIndex, itemstack);
        if (((TileEscritoire)this.tile).getWorld() == null) {
            return;
        }
        if (slotIndex == 0 && !((TileEscritoire)this.tile).getWorld().isRemote) {
            ItemStack ersatz;
            if (!AlleleManager.alleleRegistry.isIndividual(this.getStackInSlot(0)) && this.getStackInSlot(0) != null && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.getStackInSlot(0))) != null) {
                this.setInventorySlotContents(0, ersatz);
            }
            ((TileEscritoire)this.tile).getGame().initialize(this.getStackInSlot(0));
        }
    }
}

