/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.circuits.CircuitRecipe;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.SolderManager;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.datastructures.RevolvingList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemInventorySolderingIron
extends ItemInventory
implements IErrorSource,
IHintSource {
    private final RevolvingList<ICircuitLayout> layouts = new RevolvingList<ICircuitLayout>(ChipsetManager.circuitRegistry.getRegisteredLayouts().values());
    private static final short blankSlot = 0;
    private static final short finishedSlot = 1;
    private static final short ingredientSlot1 = 2;
    private static final short ingredientSlotCount = 4;

    public ItemInventorySolderingIron(EntityPlayer player, ItemStack itemStack) {
        super(player, 6, itemStack);
        this.layouts.setCurrent(ChipsetManager.circuitRegistry.getDefaultLayout());
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    public ICircuitLayout getLayout() {
        return this.layouts.getCurrent();
    }

    public void setLayout(String uid) {
        this.layouts.setCurrent(ChipsetManager.circuitRegistry.getLayout(uid));
    }

    public void advanceLayout() {
        this.layouts.rotateRight();
    }

    public void regressLayout() {
        this.layouts.rotateLeft();
    }

    private ICircuit[] getCircuits(boolean doConsume) {
        ICircuit[] circuits = new ICircuit[4];
        for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
            CircuitRecipe recipe;
            ItemStack ingredient = this.getStackInSlot(2 + i);
            if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), ingredient)) == null || ItemInventorySolderingIron.getCount(recipe.getCircuit(), circuits) >= recipe.getCircuit().getLimit()) continue;
            if (doConsume) {
                this.decrStackSize(2 + i, recipe.getResource().stackSize);
            }
            circuits[i] = recipe.getCircuit();
        }
        return circuits;
    }

    @Override
    public void onSlotClick(EntityPlayer player) {
        if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
            return;
        }
        ItemStack blank = this.getStackInSlot(0);
        if (blank == null) {
            return;
        }
        if (blank.stackSize > 1) {
            return;
        }
        if (this.getStackInSlot(1) != null) {
            return;
        }
        if (!ChipsetManager.circuitRegistry.isChipset(blank)) {
            return;
        }
        if (blank.getItemDamage() < 0 || blank.getItemDamage() >= EnumCircuitBoardType.values().length) {
            return;
        }
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.getItemDamage()];
        if (this.getCircuitCount() != type.getSockets()) {
            return;
        }
        ICircuit[] circuits = this.getCircuits(true);
        ItemStack circuitBoard = ItemCircuitBoard.createCircuitboard(type, this.layouts.getCurrent(), circuits);
        this.setInventorySlotContents(1, circuitBoard);
        this.setInventorySlotContents(0, null);
    }

    private int getCircuitCount() {
        ICircuit[] circuits = this.getCircuits(false);
        int count = 0;
        for (ICircuit circuit : circuits) {
            if (circuit == null) continue;
            ++count;
        }
        return count;
    }

    public static int getCount(ICircuit circuit, ICircuit[] circuits) {
        int count = 0;
        for (ICircuit other : circuits) {
            if (other == null || !other.getUID().equals(circuit.getUID())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        ItemStack blankCircuitBoard;
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
            errorStates.add((Object)EnumErrorCode.NO_CIRCUIT_LAYOUT);
        }
        if ((blankCircuitBoard = this.getStackInSlot(0)) == null) {
            errorStates.add((Object)EnumErrorCode.NO_CIRCUIT_BOARD);
        } else {
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blankCircuitBoard.getItemDamage()];
            int circuitCount = 0;
            for (short i = 0; i < type.getSockets(); i = (short)(i + 1)) {
                if (this.getStackInSlot(2 + i) == null) continue;
                ++circuitCount;
            }
            if (circuitCount != type.getSockets()) {
                errorStates.add((Object)EnumErrorCode.CIRCUIT_MISMATCH);
            } else {
                int count = this.getCircuitCount();
                if (count != type.getSockets()) {
                    errorStates.add((Object)EnumErrorCode.NO_CIRCUIT_LAYOUT);
                }
            }
        }
        return errorStates.build();
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.getItem();
        if (slotIndex == 0) {
            return item instanceof ItemCircuitBoard;
        }
        if (slotIndex >= 2 && slotIndex < 6) {
            CircuitRecipe recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), itemStack);
            return recipe != null;
        }
        return false;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"soldering.iron");
    }
}

