/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.wrappers;

import forestry.core.inventory.wrappers.IInvSlot;
import java.util.Iterator;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class SidedInventoryIterator
implements Iterable<IInvSlot> {
    private final ISidedInventory inv;

    SidedInventoryIterator(ISidedInventory inv) {
        this.inv = inv;
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new Iterator<IInvSlot>(){
            final int[] slots;
            int index;
            {
                this.slots = SidedInventoryIterator.this.inv.getAccessibleSlotsFromSide(0);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.slots != null && this.index < this.slots.length;
            }

            @Override
            public IInvSlot next() {
                return new InvSlot(this.slots[this.index++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        };
    }

    private class InvSlot
    implements IInvSlot {
        private final int slot;

        public InvSlot(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack getStackInSlot() {
            return SidedInventoryIterator.this.inv.getStackInSlot(this.slot);
        }

        @Override
        public void setStackInSlot(ItemStack stack) {
            SidedInventoryIterator.this.inv.setInventorySlotContents(this.slot, stack);
        }

        @Override
        public boolean canPutStackInSlot(ItemStack stack) {
            return SidedInventoryIterator.this.inv.canInsertItem(this.slot, stack, 0);
        }

        @Override
        public boolean canTakeStackFromSlot(ItemStack stack) {
            return SidedInventoryIterator.this.inv.canExtractItem(this.slot, stack, 0);
        }

        @Override
        public ItemStack decreaseStackInSlot() {
            return SidedInventoryIterator.this.inv.decrStackSize(this.slot, 1);
        }

        @Override
        public int getIndex() {
            return this.slot;
        }
    }
}

