/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.core.items.ItemForestry;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class ItemForestryTool
extends ItemForestry {
    private final ItemStack remnants;
    private float efficiencyOnProperMaterial;

    public ItemForestryTool(ItemStack remnants) {
        this.maxStackSize = 1;
        this.efficiencyOnProperMaterial = 6.0f;
        this.setMaxDamage(200);
        this.remnants = remnants;
        if (remnants != null) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void setEfficiencyOnProperMaterial(float efficiencyOnProperMaterial) {
        this.efficiencyOnProperMaterial = efficiencyOnProperMaterial;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        if (ForgeHooks.isToolEffective((ItemStack)itemstack, (Block)block, (int)metadata)) {
            return this.efficiencyOnProperMaterial;
        }
        return super.getDigSpeed(itemstack, block, metadata);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return ForgeHooks.canToolHarvestBlock((Block)block, (int)0, (ItemStack)stack);
    }

    @SubscribeEvent
    public void onDestroyCurrentItem(PlayerDestroyItemEvent event) {
        if (event.original == null || event.original.getItem() != this) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        World world = player.worldObj;
        if (!world.isRemote && this.remnants != null) {
            ItemStackUtil.dropItemStackAsEntity(this.remnants.copy(), world, player.posX, player.posY, player.posZ);
        }
    }

    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase entityliving) {
        if (block.getBlockHardness(world, x, y, z) != 0.0f) {
            itemstack.damageItem(1, entityliving);
        }
        return true;
    }

    public boolean isFull3D() {
        return true;
    }
}

