/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiblockUtil {
    public static List<IMultiblockComponent> getNeighboringParts(World world, IMultiblockComponent part) {
        ChunkCoordinates partCoord = part.getCoordinates();
        ArrayList<ChunkCoordinates> neighbors = new ArrayList<ChunkCoordinates>(ForgeDirection.VALID_DIRECTIONS.length);
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            ChunkCoordinates neighborCoord = new ChunkCoordinates(partCoord);
            neighborCoord.posX += forgeDirection.offsetX;
            neighborCoord.posY += forgeDirection.offsetY;
            neighborCoord.posZ += forgeDirection.offsetZ;
            neighbors.add(neighborCoord);
        }
        ArrayList<IMultiblockComponent> neighborParts = new ArrayList<IMultiblockComponent>();
        IChunkProvider chunkProvider = world.getChunkProvider();
        for (ChunkCoordinates neighbor : neighbors) {
            TileEntity te;
            if (!chunkProvider.chunkExists(neighbor.posX >> 4, neighbor.posZ >> 4) || !((te = world.getTileEntity(neighbor.posX, neighbor.posY, neighbor.posZ)) instanceof IMultiblockComponent)) continue;
            neighborParts.add((IMultiblockComponent)te);
        }
        return neighborParts;
    }
}

