/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;
import forestry.core.render.IBlockRenderer;
import forestry.core.tiles.TileMill;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMill
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private final ModelBase model = new ModelBase(){};
    private ResourceLocation[] textures;
    private final ModelRenderer pedestal = new ModelRenderer(this.model, 0, 0);
    private final ModelRenderer column;
    private final ModelRenderer extension;
    private final ModelRenderer blade1;
    private final ModelRenderer blade2;

    public RenderMill() {
        this.pedestal.addBox(-8.0f, -8.0f, -8.0f, 16, 1, 16);
        this.pedestal.rotationPointX = 8.0f;
        this.pedestal.rotationPointY = 8.0f;
        this.pedestal.rotationPointZ = 8.0f;
        this.column = new ModelRenderer(this.model, 0, 0);
        this.column.addBox(-2.0f, -7.0f, -2.0f, 4, 15, 4);
        this.column.rotationPointX = 8.0f;
        this.column.rotationPointY = 8.0f;
        this.column.rotationPointZ = 8.0f;
        this.extension = new ModelRenderer(this.model, 0, 0);
        this.extension.addBox(1.0f, 8.0f, 7.0f, 14, 2, 2);
        this.extension.rotationPointX = 0.0f;
        this.extension.rotationPointY = 0.0f;
        this.extension.rotationPointZ = 0.0f;
        this.blade1 = new ModelRenderer(this.model, 0, 0);
        this.blade1.addBox(-4.0f, -5.0f, -3.0f, 8, 12, 1);
        this.blade1.rotationPointX = 8.0f;
        this.blade1.rotationPointY = 8.0f;
        this.blade1.rotationPointZ = 8.0f;
        this.blade2 = new ModelRenderer(this.model, 0, 0);
        this.blade2.addBox(-4.0f, -5.0f, 2.0f, 8, 12, 1);
        this.blade2.rotationPointX = 8.0f;
        this.blade2.rotationPointY = 8.0f;
        this.blade2.rotationPointZ = 8.0f;
    }

    public RenderMill(String baseTexture) {
        this();
        this.textures = new ResourceLocation[12];
        this.textures[Textures.PEDESTAL.ordinal()] = new ForestryResource(baseTexture + "pedestal.png");
        this.textures[Textures.EXTENSION.ordinal()] = new ForestryResource(baseTexture + "extension.png");
        this.textures[Textures.BLADE_1.ordinal()] = new ForestryResource(baseTexture + "blade1.png");
        this.textures[Textures.BLADE_2.ordinal()] = new ForestryResource(baseTexture + "blade2.png");
        for (int i = 0; i < 8; ++i) {
            this.textures[Textures.CHARGE.ordinal() + i] = new ForestryResource(baseTexture + "column_" + i + ".png");
        }
    }

    public RenderMill(String baseTexture, byte charges) {
        this(baseTexture);
    }

    @Override
    public void inventoryRender(double x, double y, double z) {
        int charge = 0;
        this.render(0.0f, charge, ForgeDirection.WEST, x, y, z);
    }

    public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f) {
        TileMill tile = (TileMill)tileentity;
        this.render(tile.progress, tile.charge, ForgeDirection.WEST, d, d1, d2);
    }

    private void render(float progress, int charge, ForgeDirection orientation, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 3.99f - (progress - 0.5f) * 2.0f * 3.99f : progress * 2.0f * 3.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.pedestal.rotateAngleX = angle[0];
        this.pedestal.rotateAngleY = angle[2];
        this.pedestal.rotateAngleZ = angle[1];
        this.column.rotateAngleX = angle[0];
        this.column.rotateAngleY = angle[2];
        this.column.rotateAngleZ = angle[1];
        this.blade1.rotateAngleX = angle[0];
        this.blade1.rotateAngleY = angle[2];
        this.blade1.rotateAngleZ = angle[1];
        this.blade2.rotateAngleX = angle[0];
        this.blade2.rotateAngleY = angle[2];
        this.blade2.rotateAngleZ = angle[1];
        float factor = 0.0625f;
        Proxies.render.bindTexture(this.textures[Textures.PEDESTAL.ordinal()]);
        this.pedestal.render(factor);
        Proxies.render.bindTexture(this.textures[Textures.CHARGE.ordinal() + charge]);
        this.column.render(factor);
        Proxies.render.bindTexture(this.textures[Textures.EXTENSION.ordinal()]);
        this.extension.render(factor);
        Proxies.render.bindTexture(this.textures[Textures.BLADE_1.ordinal()]);
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.blade1.render(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        Proxies.render.bindTexture(this.textures[Textures.BLADE_2.ordinal()]);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(-translate[2] * tfactor));
        this.blade2.render(factor);
        GL11.glPopMatrix();
    }

    private static enum Textures {
        PEDESTAL,
        EXTENSION,
        BLADE_1,
        BLADE_2,
        CHARGE;

    }
}

