/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.nei.PositionedStackAdv;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiCentrifuge;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class NEIHandlerCentrifuge
extends RecipeHandlerBase {
    private static final int[][] OUTPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    private static final Comparator<Map.Entry<ItemStack, Float>> highestChanceComparator = new Comparator<Map.Entry<ItemStack, Float>>(){

        @Override
        public int compare(Map.Entry<ItemStack, Float> o1, Map.Entry<ItemStack, Float> o2) {
            return o2.getValue().compareTo(o1.getValue());
        }
    };

    @Override
    public String getRecipeID() {
        return "forestry.centrifuge";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.2.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/centrifugesocket.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(45, 18, 16, 36);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCentrifuge.class;
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(53, 25, 176, 0, 4, 17, 80, 3);
    }

    @Override
    public void loadAllRecipes() {
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            this.arecipes.add(new CachedCentrifugeRecipe(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            CachedCentrifugeRecipe crecipe = new CachedCentrifugeRecipe(recipe);
            if (crecipe.outputs == null || !crecipe.contains(crecipe.outputs, result)) continue;
            crecipe.setIngredientPermutation(crecipe.outputs, result);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadCraftingRecipes(ingred);
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInput(), (ItemStack)ingred)) continue;
            this.arecipes.add(new CachedCentrifugeRecipe(recipe, true));
        }
    }

    public class CachedCentrifugeRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack inputs;
        public List<PositionedStack> outputs = new ArrayList<PositionedStack>();

        public CachedCentrifugeRecipe(ICentrifugeRecipe recipe, boolean genPerms) {
            if (recipe.getInput() != null) {
                this.inputs = new PositionedStack((Object)recipe.getInput(), 25, 26);
            }
            if (recipe.getAllProducts() != null) {
                this.setResults(recipe.getAllProducts());
            }
        }

        public CachedCentrifugeRecipe(ICentrifugeRecipe recipe) {
            this(recipe, false);
        }

        public void setResults(Map<ItemStack, Float> outputs) {
            Set<Map.Entry<ItemStack, Float>> entrySet = outputs.entrySet();
            if (entrySet.size() == 0) {
                return;
            }
            PriorityQueue<Map.Entry<ItemStack, Float>> sortByChance = new PriorityQueue<Map.Entry<ItemStack, Float>>(entrySet.size(), highestChanceComparator);
            sortByChance.addAll(entrySet);
            int i = 0;
            while (!sortByChance.isEmpty()) {
                Map.Entry stack = (Map.Entry)sortByChance.poll();
                if (i >= OUTPUTS.length) {
                    return;
                }
                PositionedStackAdv output = new PositionedStackAdv(stack.getKey(), 93 + OUTPUTS[i][0] * 18, 8 + OUTPUTS[i][1] * 18);
                output.setChance(((Float)stack.getValue()).floatValue());
                this.outputs.add(output);
                ++i;
            }
        }

        public PositionedStack getIngredient() {
            this.randomRenderPermutation(this.inputs, NEIHandlerCentrifuge.this.cycleticks / 20);
            return this.inputs;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

