/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import forestry.farming.logic.FarmableReference;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FarmLogicEnder
extends FarmLogicHomogeneous {
    public FarmLogicEnder(IFarmHousing housing) {
        super(housing, new ItemStack(Blocks.end_stone), new ItemStack(Blocks.end_stone), (Iterable<IFarmable>)Farmables.farmables.get(FarmableReference.Ender.get()));
    }

    @Override
    public String getName() {
        return "Managed Ender Farm";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Items.ender_eye.getIconFromDamage(0);
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable farmable : this.germlings) {
                ICrop crop = farmable.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }

    @Override
    protected boolean maintainGermlings(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            ItemStack below;
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!VectUtil.isAirBlock(world, position) && !BlockUtil.isReplaceableBlock(world, position.x, position.y, position.z) || !this.isAcceptedSoil(below = VectUtil.getAsItemStack(world, position.add(0, -1, 0)))) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        World world = this.getWorld();
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }
}

