/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public abstract class AIButterflyBase
extends EntityAIBase {
    protected final EntityButterfly entity;

    protected AIButterflyBase(EntityButterfly entity) {
        this.entity = entity;
    }

    protected Vec3 getRandomDestination() {
        if (this.entity.isInWater()) {
            return this.getRandomDestinationUpwards();
        }
        Vec3 randomTarget = RandomPositionGenerator.findRandomTargetBlockAwayFrom((EntityCreature)this.entity, (int)16, (int)7, (Vec3)Vec3.createVectorHelper((double)this.entity.posX, (double)this.entity.posY, (double)this.entity.posZ));
        if (randomTarget == null) {
            return null;
        }
        if (this.validateDestination(randomTarget, false)) {
            return randomTarget;
        }
        return null;
    }

    protected Vec3 getRandomDestinationUpwards() {
        Vec3 destination = Vec3.createVectorHelper((double)this.entity.posX, (double)(this.entity.posY + (double)this.entity.getRNG().nextInt(10) + 2.0), (double)this.entity.posZ);
        if (this.validateDestination(destination, true)) {
            return destination;
        }
        return null;
    }

    private boolean validateDestination(Vec3 dest, boolean allowFluids) {
        if (dest.yCoord < 1.0) {
            return false;
        }
        Block block = this.entity.worldObj.getBlock((int)dest.xCoord, (int)dest.yCoord, (int)dest.zCoord);
        if (!allowFluids && block.getMaterial().isLiquid()) {
            return false;
        }
        if (!block.getBlocksMovement((IBlockAccess)this.entity.worldObj, (int)dest.xCoord, (int)dest.yCoord, (int)dest.zCoord)) {
            return false;
        }
        return this.entity.getButterfly().isAcceptedEnvironment(this.entity.worldObj, dest.xCoord, dest.yCoord, dest.zCoord);
    }
}

