/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.config.Config;
import forestry.core.gui.GuiHandler;
import forestry.core.inventory.ItemInventory;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.items.ItemWithGui;
import forestry.core.render.TextureManager;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.StringUtil;
import forestry.storage.BackpackMode;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.GuiBackpack;
import forestry.storage.gui.GuiBackpackT2;
import forestry.storage.inventory.ItemInventoryBackpack;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBackpack
extends ItemWithGui {
    private final IBackpackDefinition definition;
    private final EnumBackpackType type;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemBackpack(IBackpackDefinition definition, EnumBackpackType type) {
        this.definition = definition;
        this.type = type;
    }

    public IBackpackDefinition getDefinition() {
        return this.definition;
    }

    public boolean getShareTag() {
        return true;
    }

    @Override
    protected void openGui(EntityPlayer entityplayer) {
        GuiHandler.openGui(entityplayer, this, (short)this.type.ordinal());
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            if (!player.isSneaking()) {
                this.openGui(player);
            } else {
                ItemBackpack.switchMode(itemstack);
            }
        }
        return itemstack;
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return ItemBackpack.getInventoryHit(world, x, y, z, side) != null;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return false;
        }
        if (!player.isSneaking()) {
            return false;
        }
        return this.evaluateTileHit(itemstack, player, world, x, y, z, side);
    }

    public static ItemStack tryStowing(EntityPlayer player, ItemStack backpackStack, ItemStack stack) {
        ItemBackpack backpack = (ItemBackpack)backpackStack.getItem();
        ItemInventoryBackpack inventory = new ItemInventoryBackpack(player, backpack.getBackpackSize(), backpackStack);
        if (backpackStack.getItemDamage() == 1) {
            return stack;
        }
        BackpackStowEvent event = new BackpackStowEvent(player, backpack.getDefinition(), inventory, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (stack.stackSize <= 0) {
            return null;
        }
        if (event.isCanceled()) {
            return stack;
        }
        ItemStack remainder = InventoryUtil.moveItemStack(stack, (IInventory)inventory);
        stack.stackSize = remainder == null ? 0 : remainder.stackSize;
        return null;
    }

    private static void switchMode(ItemStack itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        int nextMode = mode.ordinal() + 1;
        if (!Config.enableBackpackResupply && nextMode == BackpackMode.RESUPPLY.ordinal()) {
            ++nextMode;
        }
        itemstack.setItemDamage(nextMode %= BackpackMode.values().length);
    }

    private static IInventory getInventoryHit(World world, int x, int y, int z, int side) {
        TileEntity targeted = world.getTileEntity(x, y, z);
        return TileUtil.getInventoryFromTile(targeted, ForgeDirection.getOrientation((int)side));
    }

    private boolean evaluateTileHit(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        IInventory inventory = ItemBackpack.getInventoryHit(world, x, y, z, side);
        if (inventory != null) {
            if (inventory.getSizeInventory() <= 0) {
                return true;
            }
            ItemInventoryBackpack backpackInventory = new ItemInventoryBackpack(player, this.getBackpackSize(), stack);
            BackpackMode mode = ItemBackpack.getMode(stack);
            if (mode == BackpackMode.RECEIVE) {
                this.tryChestReceive(backpackInventory, inventory);
            } else {
                ItemBackpack.tryChestTransfer(backpackInventory, inventory);
            }
            return true;
        }
        return false;
    }

    private static void tryChestTransfer(ItemInventoryBackpack backpackInventory, IInventory target) {
        for (IInvSlot slot : InventoryIterator.getIterable(backpackInventory)) {
            ItemStack packStack = slot.getStackInSlot();
            if (packStack == null) continue;
            ItemStack remaining = InventoryUtil.moveItemStack(packStack, target);
            slot.setStackInSlot(remaining);
        }
    }

    private void tryChestReceive(ItemInventoryBackpack backpackInventory, IInventory target) {
        for (IInvSlot slot : InventoryIterator.getIterable(target)) {
            ItemStack targetStack = slot.getStackInSlot();
            if (targetStack == null || !this.definition.isValidItem(targetStack)) continue;
            ItemStack remaining = InventoryUtil.moveItemStack(targetStack, (IInventory)backpackInventory);
            slot.setStackInSlot(remaining);
        }
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        int occupied = ItemInventory.getOccupiedSlotCount(itemstack);
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        if (mode == BackpackMode.LOCKED) {
            list.add(StringUtil.localize("storage.backpack.mode.locked"));
        } else if (mode == BackpackMode.RECEIVE) {
            list.add(StringUtil.localize("storage.backpack.mode.receiving"));
        } else if (mode == BackpackMode.RESUPPLY) {
            list.add(StringUtil.localize("storage.backpack.mode.resupply"));
        }
        list.add(StringUtil.localize("gui.slots").replaceAll("%USED", String.valueOf(occupied)).replaceAll("%SIZE", String.valueOf(this.getBackpackSize())));
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        return this.definition.getName(itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[6];
        EnumBackpackType t = this.type == EnumBackpackType.APIARIST ? EnumBackpackType.T1 : this.type;
        String typeTag = "backpacks/" + t.toString().toLowerCase(Locale.ENGLISH);
        this.icons[0] = TextureManager.registerTex(register, typeTag + ".cloth");
        this.icons[1] = TextureManager.registerTex(register, typeTag + ".outline");
        this.icons[2] = TextureManager.registerTex(register, "backpacks/neutral");
        this.icons[3] = TextureManager.registerTex(register, "backpacks/locked");
        this.icons[4] = TextureManager.registerTex(register, "backpacks/receive");
        this.icons[5] = TextureManager.registerTex(register, "backpacks/resupply");
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public int getColorFromItemStack(ItemStack itemstack, int j) {
        if (j == 0) {
            return this.definition.getPrimaryColour();
        }
        if (j == 1) {
            return this.definition.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int i, int j) {
        if (j == 0) {
            return this.icons[0];
        }
        if (j == 1) {
            return this.icons[1];
        }
        if (i > 2) {
            return this.icons[5];
        }
        if (i > 1) {
            return this.icons[4];
        }
        if (i > 0) {
            return this.icons[3];
        }
        return this.icons[2];
    }

    private static int getSlotsForType(EnumBackpackType type) {
        switch (type) {
            case APIARIST: {
                return 125;
            }
            case T2: {
                return 45;
            }
        }
        return 15;
    }

    public static BackpackMode getMode(ItemStack backpack) {
        int meta = backpack.getItemDamage();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack heldItem, int data) {
        if (data > EnumBackpackType.values().length) {
            return null;
        }
        EnumBackpackType type = EnumBackpackType.values()[data];
        switch (type) {
            case T1: {
                return new GuiBackpack(new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, heldItem));
            }
            case T2: {
                return new GuiBackpackT2(new ContainerBackpack(player, ContainerBackpack.Size.T2, heldItem));
            }
        }
        return null;
    }

    @Override
    public Object getContainer(EntityPlayer player, ItemStack heldItem, int data) {
        if (data > EnumBackpackType.values().length) {
            return null;
        }
        EnumBackpackType type = EnumBackpackType.values()[data];
        switch (type) {
            case T1: {
                return new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, heldItem);
            }
            case T2: {
                return new ContainerBackpack(player, ContainerBackpack.Size.T2, heldItem);
            }
        }
        return null;
    }
}

