/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.enums.Dyes;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.gui.widgets.GT_GuiTooltipManager;
import gregtech.api.interfaces.IGuiScreen;
import gregtech.api.interfaces.tileentity.ICoverable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GT_GUICover
extends GuiScreen
implements GT_GuiTooltipManager.GT_IToolTipRenderer,
IGuiScreen {
    protected GT_GuiTooltipManager ttManager = new GT_GuiTooltipManager();
    protected int gui_width = 176;
    protected int gui_height = 107;
    protected int guiTop;
    protected int guiLeft;
    protected boolean drawButtons = true;
    private GuiButton selectedButton;
    public String header;
    public GT_GuiFakeItemButton headerIcon;
    public final ICoverable tile;
    protected List<IGuiScreen.IGuiElement> elements = new ArrayList<IGuiScreen.IGuiElement>();
    protected List<GT_GuiIntegerTextBox> textBoxes = new ArrayList<GT_GuiIntegerTextBox>();

    public GT_GUICover(ICoverable tile, int width, int height, ItemStack cover) {
        this.tile = tile;
        this.gui_width = width;
        this.gui_height = height;
        this.header = cover != null ? cover.getDisplayName() : "";
        this.headerIcon = new GT_GuiFakeItemButton(this, 5, 5, null).setItem(cover);
    }

    public void initGui() {
        this.guiLeft = (this.width - this.gui_width) / 2;
        this.guiTop = (this.height - this.gui_height) / 2;
        for (IGuiScreen.IGuiElement element : this.elements) {
            if (element instanceof GuiButton) {
                this.buttonList.add(element);
            }
            if (!(element instanceof GT_GuiIntegerTextBox)) continue;
            this.textBoxes.add((GT_GuiIntegerTextBox)element);
        }
        this.onInitGui(this.guiLeft, this.guiTop, this.gui_width, this.gui_height);
        for (IGuiScreen.IGuiElement element : this.elements) {
            element.onInit();
        }
    }

    protected abstract void onInitGui(int var1, int var2, int var3, int var4);

    public void onMouseWheel(int x, int y, int delta) {
    }

    public void handleMouseInput() {
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int j = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.onMouseWheel(i, j, delta);
        }
        super.handleMouseInput();
    }

    public void drawScreen(int mouseX, int mouseY, float parTicks) {
        this.drawDefaultBackground();
        this.drawBackground(mouseX, mouseY, parTicks);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        if (this.drawButtons) {
            RenderHelper.enableGUIStandardItemLighting();
            for (IGuiScreen.IGuiElement e : this.elements) {
                e.draw(mouseX, mouseY, parTicks);
            }
        }
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawForegroundLayer(mouseX, mouseY, parTicks);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.enableStandardItemLighting();
    }

    public void drawForegroundLayer(int mouseX, int mouseY, float parTicks) {
        this.drawExtras(mouseX, mouseY, parTicks);
        this.ttManager.onTick(this, mouseX, mouseY);
    }

    public void drawBackground(int mouseX, int mouseY, float parTicks) {
        short[] color = Dyes.MACHINE_METAL.getRGBA();
        GL11.glColor3ub((byte)((byte)color[0]), (byte)((byte)color[1]), (byte)((byte)color[2]));
        this.mc.renderEngine.bindTexture(new ResourceLocation("gregtech:textures/gui/GuiCover.png"));
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.gui_width, this.gui_height);
    }

    public void drawExtras(int mouseX, int mouseY, float parTicks) {
        this.fontRendererObj.drawString(this.header, 25, 9, -14540254);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void closeScreen() {
        this.mc.displayGuiScreen((GuiScreen)null);
        this.mc.setIngameFocus();
    }

    public void updateScreen() {
        super.updateScreen();
        if (!this.tile.isUseableByPlayer((EntityPlayer)this.mc.thePlayer)) {
            this.closeScreen();
            return;
        }
        for (GuiTextField guiTextField : this.textBoxes) {
            guiTextField.updateCursorCounter();
        }
    }

    public void mouseClicked(int x, int y, int button) {
        for (GT_GuiIntegerTextBox tBox : this.textBoxes) {
            boolean hadFocus = tBox.isFocused();
            if (tBox.isEnabled() || hadFocus) {
                tBox.mouseClicked(x, y, button);
            }
            if (tBox.isFocused() && button == 1 && tBox.isEnabled()) {
                tBox.setText("0");
                continue;
            }
            if (!hadFocus || tBox.isFocused()) continue;
            this.applyTextBox(tBox);
        }
        super.mouseClicked(x, y, button);
    }

    public void keyTyped(char c, int key) {
        GT_GuiIntegerTextBox focusedTextBox = null;
        for (GT_GuiIntegerTextBox textBox : this.textBoxes) {
            if (!textBox.isFocused()) continue;
            focusedTextBox = textBox;
        }
        if (key == 1) {
            if (focusedTextBox != null) {
                this.resetTextBox(focusedTextBox);
                this.setFocusedTextBox(null);
                return;
            }
            this.closeScreen();
        }
        if (c == '\t') {
            for (int i = 0; i < this.textBoxes.size(); ++i) {
                GT_GuiIntegerTextBox box = this.textBoxes.get(i);
                if (!box.isFocused()) continue;
                this.applyTextBox(box);
                this.setFocusedTextBox(i + 1 < this.textBoxes.size() ? this.textBoxes.get(i + 1) : null);
                return;
            }
            if (this.textBoxes.size() > 0) {
                this.setFocusedTextBox(this.textBoxes.get(0));
            }
            return;
        }
        if (focusedTextBox != null && focusedTextBox.textboxKeyTyped(c, key)) {
            return;
        }
        if (key == 28 && focusedTextBox != null) {
            this.applyTextBox(focusedTextBox);
            this.setFocusedTextBox(null);
            return;
        }
        if (key == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            if (focusedTextBox != null) {
                this.applyTextBox(focusedTextBox);
                this.setFocusedTextBox(null);
                return;
            }
            this.closeScreen();
            return;
        }
        super.keyTyped(c, key);
    }

    public void actionPerformed(GuiButton button) {
        this.selectedButton = button;
    }

    @Override
    public void clearSelectedButton() {
        this.selectedButton = null;
    }

    @Override
    public GuiButton getSelectedButton() {
        return this.selectedButton;
    }

    @Override
    public void buttonClicked(GuiButton button) {
    }

    private void setFocusedTextBox(GT_GuiIntegerTextBox boxToFocus) {
        for (GT_GuiIntegerTextBox textBox : this.textBoxes) {
            textBox.setFocused(textBox.equals(boxToFocus) && textBox.isEnabled());
        }
    }

    public void applyTextBox(GT_GuiIntegerTextBox box) {
    }

    public void resetTextBox(GT_GuiIntegerTextBox box) {
    }

    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer render) {
        super.drawHoveringText(par1List, par2, par3, render);
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }

    @Override
    public void addToolTip(GT_GuiTooltip toolTip) {
        this.ttManager.addToolTip(toolTip);
    }

    @Override
    public boolean removeToolTip(GT_GuiTooltip toolTip) {
        return this.ttManager.removeToolTip(toolTip);
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getXSize() {
        return this.gui_width;
    }

    @Override
    public int getYSize() {
        return this.gui_height;
    }

    @Override
    public RenderItem getItemRenderer() {
        return itemRender;
    }

    @Override
    public void addElement(IGuiScreen.IGuiElement element) {
        if (this.elements.contains(element)) {
            return;
        }
        this.elements.add(element);
    }

    @Override
    public boolean removeElement(IGuiScreen.IGuiElement element) {
        return this.elements.remove(element);
    }
}

