/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.interfaces.IFoodStat;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;

@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore")
public abstract class GT_MetaGenerated_Item
extends GT_MetaBase_Item
implements IEdible {
    public static final ConcurrentHashMap<String, GT_MetaGenerated_Item> sInstances = new ConcurrentHashMap();
    public final short mOffset;
    public final short mItemAmount;
    public final BitSet mEnabledItems;
    public final BitSet mVisibleItems;
    public final IIcon[][] mIconList;
    public final ConcurrentHashMap<Short, IFoodStat> mFoodStats = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, Long[]> mElectricStats = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, Long[]> mFluidContainerStats = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, Short> mBurnValues = new ConcurrentHashMap();

    public GT_MetaGenerated_Item(String aUnlocalized, short aOffset, short aItemAmount) {
        super(aUnlocalized);
        this.setCreativeTab(GregTech_API.TAB_GREGTECH_MATERIALS);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.mEnabledItems = new BitSet(aItemAmount);
        this.mVisibleItems = new BitSet(aItemAmount);
        this.mOffset = (short)Math.min(32766, aOffset);
        this.mItemAmount = (short)Math.min(aItemAmount, 32766 - this.mOffset);
        this.mIconList = new IIcon[aItemAmount][1];
        sInstances.put(this.getUnlocalizedName(), this);
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < this.mItemAmount) {
            ItemStack rStack = new ItemStack((Item)this, 1, this.mOffset + aID);
            this.mEnabledItems.set(aID);
            this.mVisibleItems.set(aID);
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(rStack) + ".name", aEnglish);
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName(rStack) + ".tooltip", aToolTip);
            ArrayList<TC_Aspects.TC_AspectStack> tAspects = new ArrayList<TC_Aspects.TC_AspectStack>();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof SubTag)) continue;
                if (tRandomData == SubTag.INVISIBLE) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != SubTag.NO_UNIFICATION) continue;
                GT_OreDictUnificator.addToBlacklist(rStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IFoodStat) {
                    int tFoodValue;
                    this.setFoodBehavior(this.mOffset + aID, (IFoodStat)tRandomData);
                    if (((IFoodStat)tRandomData).getFoodAction(this, rStack) == EnumAction.eat && (tFoodValue = ((IFoodStat)tRandomData).getFoodLevel(this, rStack, null)) > 0) {
                        GT_Values.RA.addCannerRecipe(rStack, ItemList.IC2_Food_Can_Empty.get(tFoodValue, new Object[0]), ((IFoodStat)tRandomData).isRotten(this, rStack, null) ? ItemList.IC2_Food_Can_Spoiled.get(tFoodValue, new Object[0]) : ItemList.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]), null, tFoodValue * 100, 1);
                    }
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(this.mOffset + aID, (IItemBehaviour)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TC_Aspects.TC_AspectStack) {
                    ((TC_Aspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GT_Utility.isStringValid(tRandomData)) {
                        GT_OreDictUnificator.registerOre(tRandomData, rStack);
                        continue;
                    }
                    GT_OreDictUnificator.addItemData(rStack, (ItemData)tRandomData);
                    continue;
                }
                if (!tUseOreDict) continue;
                GT_OreDictUnificator.registerOre(tRandomData, rStack);
            }
            if (GregTech_API.sThaumcraftCompat != null) {
                GregTech_API.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public final GT_MetaGenerated_Item setFoodBehavior(int aMetaValue, IFoodStat aFoodBehavior) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aFoodBehavior == null) {
            this.mFoodStats.remove((short)aMetaValue);
        } else {
            this.mFoodStats.put((short)aMetaValue, aFoodBehavior);
        }
        return this;
    }

    public final GT_MetaGenerated_Item setBurnValue(int aMetaValue, int aValue) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length() || aValue < 0) {
            return this;
        }
        if (aValue == 0) {
            this.mBurnValues.remove((short)aMetaValue);
        } else {
            this.mBurnValues.put((short)aMetaValue, (short)(aValue > Short.MAX_VALUE ? Short.MAX_VALUE : (short)aValue));
        }
        return this;
    }

    public final GT_MetaGenerated_Item setElectricStats(int aMetaValue, long aMaxCharge, long aTransferLimit, long aTier, long aSpecialData, boolean aUseAnimations) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aMaxCharge == 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, new Long[]{aMaxCharge, Math.max(0L, aTransferLimit), Math.max(-1L, aTier), aSpecialData});
            if (aMetaValue >= this.mOffset && aUseAnimations) {
                this.mIconList[aMetaValue - this.mOffset] = Arrays.copyOf(this.mIconList[aMetaValue - this.mOffset], Math.max(9, this.mIconList[aMetaValue - this.mOffset].length));
            }
        }
        return this;
    }

    public final GT_MetaGenerated_Item setFluidContainerStats(int aMetaValue, long aCapacity, long aStacksize) {
        if (aMetaValue < 0 || aMetaValue >= this.mOffset + this.mEnabledItems.length()) {
            return this;
        }
        if (aCapacity < 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mFluidContainerStats.put((short)aMetaValue, new Long[]{aCapacity, Math.max(1L, aStacksize)});
        }
        return this;
    }

    public boolean useStandardMetaItemRenderer() {
        return true;
    }

    public short[] getRGBa(ItemStack aStack) {
        return Materials._NULL.getRGBA();
    }

    public IIconContainer getIconContainer(int aMetaData) {
        return null;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null && aPlayer.canEat(tStat.alwaysEdible(this, aStack, aPlayer))) {
            aPlayer.setItemInUse(aStack, 32);
        }
        return super.onItemRightClick(aStack, aWorld, aPlayer);
    }

    public int getMaxItemUseDuration(ItemStack aStack) {
        return this.mFoodStats.get((short)this.getDamage(aStack)) == null ? 0 : 32;
    }

    public EnumAction getItemUseAction(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? EnumAction.none : tStat.getFoodAction(this, aStack);
    }

    public final ItemStack onEaten(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            if (Loader.isModLoaded((String)"AppleCore")) {
                aPlayer.getFoodStats().func_151686_a((ItemFood)GT_Utility.callConstructor("squeek.applecore.api.food.ItemFoodProxy.ItemFoodProxy", 0, null, true, this), aStack);
            } else {
                aPlayer.getFoodStats().addStats(tStat.getFoodLevel(this, aStack, aPlayer), tStat.getSaturation(this, aStack, aPlayer));
            }
            tStat.onEaten(this, aStack, aPlayer);
        }
        return aStack;
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? null : new FoodValues(tStat.getFoodLevel(this, aStack, null), tStat.getSaturation(this, aStack, null));
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item var1, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack;
            if (!this.mVisibleItems.get(i) && (!GT_Values.D1 || !this.mEnabledItems.get(i))) continue;
            Long[] tStats = this.mElectricStats.get((short)(this.mOffset + i));
            if (tStats != null && tStats[3] < 0L) {
                tStack = new ItemStack((Item)this, 1, this.mOffset + i);
                this.setCharge(tStack, Math.abs(tStats[0]));
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
            if (tStats != null && tStats[3] == -2L) continue;
            tStack = new ItemStack((Item)this, 1, this.mOffset + i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void registerIcons(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (!this.mEnabledItems.get(i)) continue;
            for (int k = 1; k < this.mIconList[i].length; k = (int)((byte)(k + 1))) {
                this.mIconList[i][k] = aIconRegister.registerIcon("gregtech:" + (GT_Config.troll ? "troll" : this.getUnlocalizedName() + "/" + i + "/" + k));
            }
            this.mIconList[i][0] = aIconRegister.registerIcon("gregtech:" + (GT_Config.troll ? "troll" : this.getUnlocalizedName() + "/" + i));
        }
    }

    @Override
    public final Long[] getElectricStats(ItemStack aStack) {
        return this.mElectricStats.get((short)aStack.getItemDamage());
    }

    @Override
    public final Long[] getFluidContainerStats(ItemStack aStack) {
        return this.mFluidContainerStats.get((short)aStack.getItemDamage());
    }

    @Override
    public int getItemEnchantability() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean getIsRepairable(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }
}

