/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.tool.ITool;
import forestry.api.arboriculture.IToolGrafter;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enchants.Enchantment_Radioactivity;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.tools.GT_Tool_Turbine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="forestry.api.arboriculture.IToolGrafter", modid="Forestry"), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolCrowbar", modid="Railcraft"), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft"), @Optional.Interface(iface="crazypants.enderio.api.tool.ITool", modid="EnderIO")})
public abstract class GT_MetaGenerated_Tool
extends GT_MetaBase_Item
implements IDamagableItem,
IToolGrafter,
IToolCrowbar,
IToolWrench,
ITool {
    public static final ConcurrentHashMap<String, GT_MetaGenerated_Tool> sInstances = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, IToolStats> mToolStats = new ConcurrentHashMap();

    public GT_MetaGenerated_Tool(String aUnlocalized) {
        super(aUnlocalized);
        GT_ModHandler.registerBoxableItemToToolBox(this);
        this.setCreativeTab(GregTech_API.TAB_GREGTECH);
        this.setMaxStackSize(1);
        sInstances.put(this.getUnlocalizedName(), this);
    }

    public static final Materials getPrimaryMaterial(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            return Materials.getRealMaterial(aNBT.getString("PrimaryMaterial"));
        }
        return Materials._NULL;
    }

    public static final Materials getSecondaryMaterial(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            return Materials.getRealMaterial(aNBT.getString("SecondaryMaterial"));
        }
        return Materials._NULL;
    }

    public static final long getToolMaxDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            return aNBT.getLong("MaxDamage");
        }
        return 0L;
    }

    public static final long getToolDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            return aNBT.getLong("Damage");
        }
        return 0L;
    }

    public static final boolean setToolDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null) {
            aNBT.setLong("Damage", aDamage);
            return true;
        }
        return false;
    }

    public final ItemStack addTool(int aID, String aEnglish, String aToolTip, IToolStats aToolStats, Object ... aOreDictNamesAndAspects) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < 32766 && aID % 2 == 0) {
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName() + "." + aID + ".name", aEnglish);
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName() + "." + aID + ".tooltip", aToolTip);
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName() + "." + (aID + 1) + ".name", aEnglish + " (Empty)");
            GT_LanguageManager.addStringLocalization(this.getUnlocalizedName() + "." + (aID + 1) + ".tooltip", "You need to recharge it");
            this.mToolStats.put((short)aID, aToolStats);
            this.mToolStats.put((short)(aID + 1), aToolStats);
            aToolStats.onStatsAddedToTool(this, aID);
            ItemStack rStack = new ItemStack((Item)this, 1, aID);
            ArrayList<TC_Aspects.TC_AspectStack> tAspects = new ArrayList<TC_Aspects.TC_AspectStack>();
            for (Object tOreDictNameOrAspect : aOreDictNamesAndAspects) {
                if (tOreDictNameOrAspect instanceof TC_Aspects.TC_AspectStack) {
                    ((TC_Aspects.TC_AspectStack)tOreDictNameOrAspect).addToAspectList(tAspects);
                    continue;
                }
                GT_OreDictUnificator.registerOre(tOreDictNameOrAspect, rStack);
            }
            if (GregTech_API.sThaumcraftCompat != null) {
                GregTech_API.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public final ItemStack getToolWithStats(int aToolID, int aAmount, Materials aPrimaryMaterial, Materials aSecondaryMaterial, long[] aElectricArray) {
        ItemStack rStack = new ItemStack((Item)this, aAmount, aToolID);
        IToolStats tToolStats = this.getToolStats(rStack);
        if (tToolStats != null) {
            NBTTagCompound tMainNBT = new NBTTagCompound();
            NBTTagCompound tToolNBT = new NBTTagCompound();
            if (aPrimaryMaterial != null) {
                tToolNBT.setString("PrimaryMaterial", aPrimaryMaterial.mName);
                tToolNBT.setLong("MaxDamage", 100L * (long)((float)aPrimaryMaterial.mDurability * tToolStats.getMaxDurabilityMultiplier()));
            }
            if (aSecondaryMaterial != null) {
                tToolNBT.setString("SecondaryMaterial", aSecondaryMaterial.mName);
            }
            if (aElectricArray != null) {
                tToolNBT.setBoolean("Electric", true);
                tToolNBT.setLong("MaxCharge", aElectricArray[0]);
                tToolNBT.setLong("Voltage", aElectricArray[1]);
                tToolNBT.setLong("Tier", aElectricArray[2]);
                tToolNBT.setLong("SpecialData", aElectricArray[3]);
            }
            tMainNBT.setTag("GT.ToolStats", (NBTBase)tToolNBT);
            rStack.setTagCompound(tMainNBT);
        }
        this.isItemStackUsable(rStack);
        return rStack;
    }

    @Mod.EventHandler
    public void onHarvestBlockEvent(ArrayList<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        if (this.isItemStackUsable(aStack) && this.getDigSpeed(aStack, aBlock, aMetaData) > 0.0f) {
            this.doDamage(aStack, tStats.convertBlockDrops(aDrops, aStack, aPlayer, aBlock, aX, aY, aZ, aMetaData, aFortune, aSilkTouch, aEvent) * tStats.getToolDamagePerDropConversion());
        }
    }

    @Mod.EventHandler
    public float onBlockBreakSpeedEvent(float aDefault, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, PlayerEvent.BreakSpeed aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats == null ? aDefault : tStats.getMiningSpeed(aBlock, aMetaData, aDefault, aPlayer, aPlayer.worldObj, aX, aY, aZ);
    }

    public boolean onBlockStartBreak(ItemStack aStack, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        if (aPlayer.worldObj.isRemote) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        Block aBlock = aPlayer.worldObj.getBlock(aX, aY, aZ);
        if (tStats.isChainsaw() && aBlock instanceof IShearable) {
            IShearable target = (IShearable)aBlock;
            if (target.isShearable(aStack, (IBlockAccess)aPlayer.worldObj, aX, aY, aZ)) {
                ArrayList drops = target.onSheared(aStack, (IBlockAccess)aPlayer.worldObj, aX, aY, aZ, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)aStack));
                for (ItemStack stack : drops) {
                    float f = 0.7f;
                    double d = (double)(itemRand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(itemRand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(itemRand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(aPlayer.worldObj, (double)aX + d, (double)aY + d1, (double)aZ + d2, stack);
                    entityitem.delayBeforeCanPickup = 10;
                    aPlayer.worldObj.spawnEntityInWorld((Entity)entityitem);
                }
                aPlayer.addStat(StatList.mineBlockStatArray[Block.getIdFromBlock((Block)aBlock)], 1);
                this.onBlockDestroyed(aStack, aPlayer.worldObj, aBlock, aX, aY, aZ, (EntityLivingBase)aPlayer);
            }
            return false;
        }
        return super.onBlockStartBreak(aStack, aX, aY, aZ, aPlayer);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || !this.isItemStackUsable(aStack)) {
            return true;
        }
        GT_Utility.doSoundAtClient(tStats.getEntityHitSound(), 1, 1.0f);
        if (super.onLeftClickEntity(aStack, aPlayer, aEntity)) {
            return true;
        }
        if (aEntity.canAttackWithItem() && !aEntity.hitByEntity((Entity)aPlayer)) {
            float tMagicDamage = tStats.getMagicDamageAgainstEntity(aEntity instanceof EntityLivingBase ? EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0.0f, aEntity, aStack, aPlayer);
            float tDamage = tStats.getNormalDamageAgainstEntity((float)aPlayer.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue() + this.getToolCombatDamage(aStack), aEntity, aStack, aPlayer);
            if (tDamage + tMagicDamage > 0.0f) {
                boolean tCriticalHit;
                boolean bl = tCriticalHit = aPlayer.fallDistance > 0.0f && !aPlayer.onGround && !aPlayer.isOnLadder() && !aPlayer.isInWater() && !aPlayer.isPotionActive(Potion.blindness) && aPlayer.ridingEntity == null && aEntity instanceof EntityLivingBase;
                if (tCriticalHit && tDamage > 0.0f) {
                    tDamage *= 1.5f;
                }
                if (aEntity.attackEntityFrom(tStats.getDamageSource((EntityLivingBase)aPlayer, aEntity), tDamage += tMagicDamage)) {
                    int tKnockcack;
                    if (aEntity instanceof EntityLivingBase) {
                        aEntity.setFire(EnchantmentHelper.getFireAspectModifier((EntityLivingBase)aPlayer) * 4);
                    }
                    if ((tKnockcack = (aPlayer.isSprinting() ? 1 : 0) + (aEntity instanceof EntityLivingBase ? EnchantmentHelper.getKnockbackModifier((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0)) > 0) {
                        aEntity.addVelocity((double)(-MathHelper.sin((float)(aPlayer.rotationYaw * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f), 0.1, (double)(MathHelper.cos((float)(aPlayer.rotationYaw * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f));
                        aPlayer.motionX *= 0.6;
                        aPlayer.motionZ *= 0.6;
                        aPlayer.setSprinting(false);
                    }
                    if (tCriticalHit) {
                        aPlayer.onCriticalHit(aEntity);
                    }
                    if (tMagicDamage > 0.0f) {
                        aPlayer.onEnchantmentCritical(aEntity);
                    }
                    if (tDamage >= 18.0f) {
                        aPlayer.triggerAchievement((StatBase)AchievementList.overkill);
                    }
                    aPlayer.setLastAttacker(aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)aEntity), (Entity)aPlayer);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)aPlayer, (Entity)aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        aPlayer.addStat(StatList.damageDealtStat, Math.round(tDamage * 10.0f));
                    }
                    aEntity.hurtResistantTime = Math.max(1, tStats.getHurtResistanceTime(aEntity.hurtResistantTime, aEntity));
                    aPlayer.addExhaustion(0.3f);
                    this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
                }
            }
        }
        if (aStack.stackSize <= 0) {
            aPlayer.destroyCurrentEquippedItem();
        }
        return true;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            aPlayer.setItemInUse(aStack, 72000);
        }
        return super.onItemRightClick(aStack, aWorld, aPlayer);
    }

    public final int getMaxItemUseDuration(ItemStack aStack) {
        return 72000;
    }

    public final EnumAction getItemUseAction(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            return EnumAction.block;
        }
        return EnumAction.none;
    }

    @SideOnly(value=Side.CLIENT)
    public final void getSubItems(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < 32766; i += 2) {
            if (this.getToolStats(new ItemStack((Item)this, 1, i)) == null) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
            aList.add(this.getToolWithStats(i, 1, Materials.Neutronium, Materials.Neutronium, null));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void registerIcons(IIconRegister aIconRegister) {
    }

    @Override
    public final IIcon getIconFromDamage(int aMetaData) {
        return null;
    }

    @Override
    public void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        int tOffset;
        long tMaxDamage = GT_MetaGenerated_Tool.getToolMaxDamage(aStack);
        Materials tMaterial = GT_MetaGenerated_Tool.getPrimaryMaterial(aStack);
        IToolStats tStats = this.getToolStats(aStack);
        int n = tOffset = this.getElectricStats(aStack) != null ? 2 : 1;
        if (tStats != null) {
            if (tStats instanceof GT_Tool_Turbine) {
                GT_MetaGenerated_Tool cfr_ignored_0 = (GT_MetaGenerated_Tool)aStack.getItem();
                int aOptFlow = GT_Utility.safeInt((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.getItem()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f));
                aList.add(tOffset + 0, EnumChatFormatting.WHITE + String.format(this.trans("001", "Durability: %s/%s"), "" + EnumChatFormatting.GREEN + (tMaxDamage - GT_MetaGenerated_Tool.getToolDamage(aStack)) + " ", " " + tMaxDamage) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + String.format(this.trans("002", "%s lvl %s"), tMaterial.mLocalizedName + EnumChatFormatting.YELLOW, "" + this.getHarvestLevel(aStack, "")) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + String.format(this.trans("005", "Turbine Efficiency: %s"), "" + EnumChatFormatting.BLUE + (50.0f + 10.0f * this.getToolCombatDamage(aStack))) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + String.format(this.trans("006", "Optimal Steam flow: %sL/sec"), "" + EnumChatFormatting.GOLD + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 1000.0f) + EnumChatFormatting.GRAY));
                int aBaseEff = (int)(5.0f + this.getToolCombatDamage(aStack)) * 1000;
                int aOptFlowLoose = aOptFlow * 4;
                if (aBaseEff > 10000) {
                    aOptFlowLoose = (int)((double)aOptFlowLoose * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                    aBaseEff = 7500;
                } else if (aBaseEff > 7500) {
                    aOptFlowLoose = (int)((double)aOptFlowLoose * Math.pow(1.1f, (float)(aBaseEff - 7500) / 10000.0f * 20.0f));
                    aBaseEff = (int)((float)aBaseEff * 0.75f);
                } else {
                    aBaseEff = (int)((float)aBaseEff * 0.75f);
                }
                aList.add(tOffset + 4, EnumChatFormatting.GRAY + String.format(this.trans("500", "Turbine Efficiency (Loose): %s"), "" + EnumChatFormatting.BLUE + (float)aBaseEff / 100.0f) + EnumChatFormatting.DARK_GRAY);
                aList.add(tOffset + 5, EnumChatFormatting.GRAY + String.format(this.trans("501", "Optimal Steam flow (Loose): %s L/t"), "" + EnumChatFormatting.GOLD + aOptFlowLoose + EnumChatFormatting.DARK_GRAY));
                aList.add(tOffset + 6, EnumChatFormatting.WHITE + String.format(this.trans("007", "Optimal Gas flow(EU burnvalue per tick): %sEU/t"), "" + EnumChatFormatting.GOLD + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f) + EnumChatFormatting.GRAY));
                aList.add(tOffset + 7, EnumChatFormatting.WHITE + String.format(this.trans("008", "Optimal Plasma flow(Plasma energyvalue per tick): %sEU/t"), "" + EnumChatFormatting.GOLD + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 2000.0f) + EnumChatFormatting.GRAY));
            } else {
                aList.add(tOffset + 0, EnumChatFormatting.WHITE + String.format(this.trans("001", "Durability: %s/%s"), "" + EnumChatFormatting.GREEN + (tMaxDamage - GT_MetaGenerated_Tool.getToolDamage(aStack)) + " ", " " + tMaxDamage) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + String.format(this.trans("002", "%s lvl %s"), tMaterial.mLocalizedName + EnumChatFormatting.YELLOW, "" + this.getHarvestLevel(aStack, "")) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + String.format(this.trans("003", "Attack Damage: %s"), "" + EnumChatFormatting.BLUE + this.getToolCombatDamage(aStack)) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + String.format(this.trans("004", "Mining Speed: %s"), "" + EnumChatFormatting.GOLD + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed)) + EnumChatFormatting.GRAY);
                NBTTagCompound aNBT = aStack.getTagCompound();
                if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null && aNBT.hasKey("Heat")) {
                    int tHeat = aNBT.getInteger("Heat");
                    long tWorldTime = aPlayer.getEntityWorld().getWorldTime();
                    if (aNBT.hasKey("HeatTime")) {
                        long tHeatTime = aNBT.getLong("HeatTime");
                        if (tWorldTime > tHeatTime + 10L && (tHeat = (int)((long)tHeat - (tWorldTime - tHeatTime) / 10L)) < 300 && tHeat > -10000) {
                            tHeat = 300;
                        }
                        aNBT.setLong("HeatTime", tWorldTime);
                        if (tHeat > -10000) {
                            aNBT.setInteger("Heat", tHeat);
                        }
                    }
                    aList.add(tOffset + 3, EnumChatFormatting.RED + "Heat: " + aNBT.getInteger("Heat") + " K" + EnumChatFormatting.GRAY);
                }
            }
        }
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }

    @Override
    public Long[] getElectricStats(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null && (aNBT = aNBT.getCompoundTag("GT.ToolStats")) != null && aNBT.getBoolean("Electric")) {
            return new Long[]{aNBT.getLong("MaxCharge"), aNBT.getLong("Voltage"), aNBT.getLong("Tier"), aNBT.getLong("SpecialData")};
        }
        return null;
    }

    public float getToolCombatDamage(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return 0.0f;
        }
        return tStats.getBaseDamage() + (float)GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
    }

    @Override
    public final boolean doDamageToItem(ItemStack aStack, int aVanillaDamage) {
        return this.doDamage(aStack, aVanillaDamage * 100);
    }

    public final boolean doDamage(ItemStack aStack, long aAmount) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        Long[] tElectric = this.getElectricStats(aStack);
        if (tElectric == null) {
            IToolStats tStats;
            long tNewDamage = GT_MetaGenerated_Tool.getToolDamage(aStack) + aAmount;
            GT_MetaGenerated_Tool.setToolDamage(aStack, tNewDamage);
            if (tNewDamage >= GT_MetaGenerated_Tool.getToolMaxDamage(aStack) && ((tStats = this.getToolStats(aStack)) == null || GT_Utility.setStack(aStack, tStats.getBrokenItem(aStack)) == null)) {
                if (tStats != null) {
                    GT_Utility.doSoundAtClient(tStats.getBreakingSound(), 1, 1.0f);
                }
                if (aStack.stackSize > 0) {
                    --aStack.stackSize;
                }
            }
            return true;
        }
        if (this.use(aStack, (int)aAmount, null)) {
            if (ThreadLocalRandom.current().nextInt(0, 25) == 0) {
                IToolStats tStats;
                long tNewDamage = GT_MetaGenerated_Tool.getToolDamage(aStack) + aAmount;
                GT_MetaGenerated_Tool.setToolDamage(aStack, tNewDamage);
                if (tNewDamage >= GT_MetaGenerated_Tool.getToolMaxDamage(aStack) && ((tStats = this.getToolStats(aStack)) == null || GT_Utility.setStack(aStack, tStats.getBrokenItem(aStack)) == null)) {
                    if (tStats != null) {
                        GT_Utility.doSoundAtClient(tStats.getBreakingSound(), 1, 1.0f);
                    }
                    if (aStack.stackSize > 0) {
                        --aStack.stackSize;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack aStack, Block aBlock, int aMetaData) {
        if (!this.isItemStackUsable(aStack)) {
            return 0.0f;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || Math.max(0, this.getHarvestLevel(aStack, "")) < aBlock.getHarvestLevel(aMetaData)) {
            return 0.0f;
        }
        if (aBlock.getHarvestLevel(aMetaData) == 0 && !tStats.isMinableBlock(aBlock, (byte)aMetaData)) {
            return Math.min(Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed / 2.0f), 1.0f);
        }
        return tStats.isMinableBlock(aBlock, (byte)aMetaData) ? Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed) : 0.0f;
    }

    public final boolean canHarvestBlock(Block aBlock, ItemStack aStack) {
        return this.getDigSpeed(aStack, aBlock, 0) > 0.0f;
    }

    public final int getHarvestLevel(ItemStack aStack, String aToolClass) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats == null ? -1 : tStats.getBaseQuality() + GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
    }

    public boolean onBlockDestroyed(ItemStack aStack, World aWorld, Block aBlock, int aX, int aY, int aZ, EntityLivingBase aPlayer) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return false;
        }
        GT_Utility.doSoundAtClient(tStats.getMiningSound(), 1, 1.0f);
        this.doDamage(aStack, (int)Math.max(1.0f, aBlock.getBlockHardness(aWorld, aX, aY, aZ) * (float)tStats.getToolDamagePerBlockBreak()));
        return this.getDigSpeed(aStack, aBlock, aWorld.getBlockMetadata(aX, aY, aZ)) > 0.0f;
    }

    @Override
    public final ItemStack getContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack, true);
    }

    @Override
    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack, false) != null;
    }

    private ItemStack getContainerItem(ItemStack aStack, boolean playSound) {
        if (!this.isItemStackUsable(aStack)) {
            return null;
        }
        IToolStats tStats = this.getToolStats(aStack = GT_Utility.copyAmount(1L, aStack));
        if (tStats == null) {
            return null;
        }
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft());
        Object object = aStack = aStack.stackSize > 0 ? aStack : null;
        if (playSound && GT_Mod.gregtechproxy.mTicksUntilNextCraftSound <= 0) {
            GT_Mod.gregtechproxy.mTicksUntilNextCraftSound = 10;
            String sound = aStack == null ? tStats.getBreakingSound() : tStats.getCraftingSound();
            GT_Utility.doSoundAtClient(sound, 1, 1.0f);
        }
        return aStack;
    }

    public IToolStats getToolStats(ItemStack aStack) {
        this.isItemStackUsable(aStack);
        return this.getToolStatsInternal(aStack);
    }

    private IToolStats getToolStatsInternal(ItemStack aStack) {
        return aStack == null ? null : this.mToolStats.get((short)aStack.getItemDamage());
    }

    public float getSaplingModifier(ItemStack aStack, World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isGrafter() ? Math.min(100.0f, (float)(1 + this.getHarvestLevel(aStack, "")) * 20.0f) : 0.0f;
    }

    public boolean canWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        if (player == null) {
            return false;
        }
        if (player.getCurrentEquippedItem() == null) {
            return false;
        }
        if (!this.isItemStackUsable(player.getCurrentEquippedItem())) {
            return false;
        }
        IToolStats tStats = this.getToolStats(player.getCurrentEquippedItem());
        return tStats != null && tStats.isWrench();
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        if (player == null) {
            return;
        }
        if (player.getCurrentEquippedItem() == null) {
            return;
        }
        IToolStats tStats = this.getToolStats(player.getCurrentEquippedItem());
        if (tStats != null) {
            this.doDamage(player.getCurrentEquippedItem(), tStats.getToolDamagePerEntityAttack());
        }
    }

    public boolean canUse(ItemStack stack, EntityPlayer player, int x, int y, int z) {
        return this.canWrench(player, x, y, z);
    }

    public void used(ItemStack stack, EntityPlayer player, int x, int y, int z) {
        this.wrenchUsed(player, x, y, z);
    }

    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (player.getCurrentEquippedItem() == null) {
            return false;
        }
        if (!this.isItemStackUsable(player.getCurrentEquippedItem())) {
            return false;
        }
        IToolStats tStats = this.getToolStats(player.getCurrentEquippedItem());
        return tStats.isWrench();
    }

    public boolean canLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    public boolean canBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && aPlayer != null) {
            tStats.onToolCrafted(aStack, aPlayer);
        }
        super.onCreated(aStack, aWorld, aPlayer);
    }

    public final boolean doesContainerItemLeaveCraftingGrid(ItemStack aStack) {
        return false;
    }

    @Override
    public final int getItemStackLimit(ItemStack aStack) {
        return 1;
    }

    public boolean isFull3D() {
        return true;
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (aStack.getItemDamage() % 2 != 0 || tStats == null) {
            NBTTagCompound aNBT = aStack.getTagCompound();
            if (aNBT != null) {
                aNBT.removeTag("ench");
            }
            return false;
        }
        Materials aMaterial = GT_MetaGenerated_Tool.getPrimaryMaterial(aStack);
        ConcurrentHashMap<Integer, Integer> tMap = new ConcurrentHashMap<Integer, Integer>();
        ConcurrentHashMap tResult = new ConcurrentHashMap();
        if (aMaterial.mEnchantmentTools != null) {
            tMap.put(aMaterial.mEnchantmentTools.effectId, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            if (aMaterial.mEnchantmentTools == Enchantment.fortune) {
                tMap.put(Enchantment.looting.effectId, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
            if (aMaterial.mEnchantmentTools == Enchantment.knockback) {
                tMap.put(Enchantment.power.effectId, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
            if (aMaterial.mEnchantmentTools == Enchantment.fireAspect) {
                tMap.put(Enchantment.flame.effectId, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
        }
        Enchantment[] tEnchants = tStats.getEnchantments(aStack);
        int[] tLevels = tStats.getEnchantmentLevels(aStack);
        for (int i = 0; i < tEnchants.length; ++i) {
            if (tLevels[i] <= 0) continue;
            Integer tLevel = (Integer)tMap.get(tEnchants[i].effectId);
            tMap.put(tEnchants[i].effectId, tLevel == null ? tLevels[i] : (tLevel == tLevels[i] ? tLevel + 1 : Math.max(tLevel, tLevels[i])));
        }
        for (Map.Entry tEntry : tMap.entrySet()) {
            if ((Integer)tEntry.getKey() == 33 || (Integer)tEntry.getKey() == 20 && (Integer)tEntry.getValue() > 2 || (Integer)tEntry.getKey() == Enchantment_Radioactivity.INSTANCE.effectId) {
                tResult.put(tEntry.getKey(), tEntry.getValue());
                continue;
            }
            switch (Enchantment.enchantmentsList[((Integer)tEntry.getKey()).intValue()].type) {
                case weapon: {
                    if (!tStats.isWeapon()) break;
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                    break;
                }
                case all: {
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                    break;
                }
                case armor: 
                case armor_feet: 
                case armor_head: 
                case armor_legs: 
                case armor_torso: {
                    break;
                }
                case bow: {
                    if (!tStats.isRangedWeapon()) break;
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                    break;
                }
                case breakable: {
                    break;
                }
                case fishing_rod: {
                    break;
                }
                case digger: {
                    if (!tStats.isMiningTool()) break;
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                }
            }
        }
        EnchantmentHelper.setEnchantments(tResult, (ItemStack)aStack);
        return true;
    }

    @Override
    public short getChargedMetaData(ItemStack aStack) {
        return (short)(aStack.getItemDamage() - aStack.getItemDamage() % 2);
    }

    @Override
    public short getEmptyMetaData(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.getTagCompound();
        if (aNBT != null) {
            aNBT.removeTag("ench");
        }
        return (short)(aStack.getItemDamage() + 1 - aStack.getItemDamage() % 2);
    }

    @Override
    public int getItemEnchantability() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean getIsRepairable(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }
}

