/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_TileEntityCover
extends GT_Packet {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected byte side;
    protected int coverID;
    protected int coverData;
    protected int dimID;

    public GT_Packet_TileEntityCover() {
        super(true);
    }

    public GT_Packet_TileEntityCover(int mX, short mY, int mZ, byte coverSide, int coverID, int coverData, int dimID) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = dimID;
    }

    public GT_Packet_TileEntityCover(byte coverSide, int coverID, int coverData, ICoverable tile) {
        super(false);
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
        this.dimID = tile.getWorld().provider.dimensionId;
    }

    @Override
    public byte getPacketID() {
        return 6;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)23);
        tOut.writeInt(this.mX);
        tOut.writeShort((int)this.mY);
        tOut.writeInt(this.mZ);
        tOut.writeByte((int)this.side);
        tOut.writeInt(this.coverID);
        tOut.writeInt(this.coverData);
        tOut.writeInt(this.dimID);
        return tOut.toByteArray();
    }

    @Override
    public GT_Packet decode(ByteArrayDataInput aData) {
        return new GT_Packet_TileEntityCover(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        TileEntity tile;
        WorldServer world = DimensionManager.getWorld((int)this.dimID);
        if (world != null && (tile = world.getTileEntity(this.mX, (int)this.mY, this.mZ)) instanceof IGregTechTileEntity && !((IGregTechTileEntity)tile).isDead()) {
            ((IGregTechTileEntity)tile).receiveCoverData(this.side, this.coverID, this.coverData);
        }
    }
}

