/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public class GT_CopiedBlockTexture
implements ITexture {
    private final Block mBlock;
    private final byte mSide;
    private final byte mMeta;
    private final boolean mAllowAlpha;
    public short[] mRGBa;

    public GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_CopiedBlockTexture");
        }
        this.mBlock = aBlock;
        this.mRGBa = aRGBa;
        this.mSide = (byte)aSide;
        this.mMeta = (byte)aMeta;
        this.mAllowAlpha = aAllowAlpha;
    }

    public GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta, short[] aRGBa) {
        this(aBlock, aSide, aMeta, aRGBa, true);
    }

    public GT_CopiedBlockTexture(Block aBlock, int aSide, int aMeta) {
        this(aBlock, aSide, aMeta, Dyes._NULL.mRGBa);
    }

    private final IIcon getIcon(int aSide) {
        if (this.mSide == 6) {
            return this.mBlock.getIcon(aSide, (int)this.mMeta);
        }
        return this.mBlock.getIcon((int)this.mSide, (int)this.mMeta);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(5);
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(4);
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(1);
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 1.0f), (int)((float)this.mRGBa[1] * 1.0f), (int)((float)this.mRGBa[2] * 1.0f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(0);
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.5f), (int)((float)this.mRGBa[1] * 0.5f), (int)((float)this.mRGBa[2] * 0.5f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceYNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(3);
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(2);
        Tessellator.instance.setColorRGBA((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
    }

    @Override
    public boolean isValidTexture() {
        return this.mBlock != null;
    }

    public Block getBlock() {
        return this.mBlock;
    }

    public byte getMeta() {
        return this.mMeta;
    }
}

