/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.InventoryPlayer;

public class GT_GUIContainer_FusionReactor
extends GT_GUIContainerMetaTile_Machine {
    public String mNEI;
    String mName = "";

    public GT_GUIContainer_FusionReactor(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, String aName, String aTextureFile, String aNEI) {
        super(new GT_Container_MultiMachine(aInventoryPlayer, aTileEntity, false), "gregtech:textures/gui/multimachines/" + (aTextureFile == null ? "MultiblockDisplay" : aTextureFile));
        this.mName = aName;
        this.mNEI = aNEI;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(this.mName, 8, -10, 0xFAFAFF);
        if (this.mContainer != null) {
            if ((((GT_Container_MultiMachine)this.mContainer).mDisplayErrorCode & 0x40) != 0) {
                this.fontRendererObj.drawString("Incomplete Structure.", 10, 8, 0xFAFAFF);
            }
            if (((GT_Container_MultiMachine)this.mContainer).mDisplayErrorCode == 0) {
                if (((GT_Container_MultiMachine)this.mContainer).mActive == 0) {
                    this.fontRendererObj.drawString("Hit with Soft Mallet to (re-)start the Machine if it doesn't start.", -70, 170, 0xFAFAFF);
                } else {
                    this.fontRendererObj.drawString("Running perfectly.", 10, 170, 0xFAFAFF);
                }
            }
            if (this.mContainer.mEnergy > 160000000 && this.mContainer.mEnergy < 160010000) {
                this.fontRendererObj.drawString("160,000,000 EU", 50, 155, 0xFF0000);
            } else if (this.mContainer.mEnergy > 320000000 && this.mContainer.mEnergy < 320010000) {
                this.fontRendererObj.drawString("320,000,000 EU", 50, 155, 0xFF0000);
            } else if (this.mContainer.mEnergy > 640000000 && this.mContainer.mEnergy < 640010000) {
                this.fontRendererObj.drawString("640,000,000 EU", 50, 155, 0xFF0000);
            } else {
                this.fontRendererObj.drawString(GT_Utility.formatNumbers(this.mContainer.mEnergy) + " EU", 50, 155, 0xFF0000);
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.mContainer != null) {
            double tScale = (double)this.mContainer.mEnergy / (double)this.mContainer.mStorage;
            this.drawTexturedModalRect(x + 5, y + 156, 0, 251, Math.min(147, (int)(tScale * 148.0)), 5);
        }
    }
}

