/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor.gui;

import gregtech.common.items.armor.ArmorData;
import gregtech.common.items.armor.gui.InventoryArmor;
import gregtech.common.items.armor.gui.SlotFluid;
import gregtech.common.items.armor.gui.SlotLocked;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerModularArmor
extends Container {
    public InventoryArmor mInvArmor;

    public ContainerModularArmor(EntityPlayer player, InventoryArmor aInvArmor) {
        this.mInvArmor = aInvArmor;
        this.addSlots(player.inventory);
    }

    public ArmorData getData(EntityPlayer aPlayer) {
        return null;
    }

    public boolean canInteractWith(EntityPlayer aPlayer) {
        return true;
    }

    public abstract void addSlots(InventoryPlayer var1);

    public abstract int getSlotCount();

    public abstract int getShiftClickSlotCount();

    public void saveInventory(EntityPlayer entityplayer) {
        this.mInvArmor.onGuiSaved(entityplayer);
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        if (!player.worldObj.isRemote) {
            this.saveInventory(player);
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        if (player == null) {
            return null;
        }
        ItemStack originalStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        int numSlots = this.inventorySlots.size();
        if (slot != null && slot.getHasStack()) {
            ItemStack stackInSlot = slot.getStack();
            originalStack = stackInSlot.copy();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.onSlotChange(stackInSlot, originalStack);
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (stackInSlot.stackSize == originalStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, stackInSlot);
        }
        return originalStack;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.inventorySlots.get(machineIndex);
            if (slot.getHasStack() || slot instanceof SlotLocked || slot instanceof SlotFluid || !slot.isItemValid(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.isStackable()) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot == null || !ContainerModularArmor.isIdenticalItem(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.stackSize + stackToShift.stackSize;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                if (resultingStackSize <= max) {
                    stackToShift.stackSize = 0;
                    stackInSlot.stackSize = resultingStackSize;
                    slot.onSlotChanged();
                    changed = true;
                    continue;
                }
                if (stackInSlot.stackSize >= max) continue;
                stackToShift.stackSize -= max - stackInSlot.stackSize;
                stackInSlot.stackSize = max;
                slot.onSlotChanged();
                changed = true;
            }
        }
        if (stackToShift.stackSize > 0) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                stackInSlot = stackToShift.copy();
                stackInSlot.stackSize = Math.min(stackToShift.stackSize, max);
                stackToShift.stackSize -= stackInSlot.stackSize;
                slot.putStack(stackInSlot);
                slot.onSlotChanged();
                changed = true;
            }
        }
        return changed;
    }

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.getItem() != rhs.getItem()) {
            return false;
        }
        if (lhs.getItemDamage() != Short.MAX_VALUE && lhs.getItemDamage() != rhs.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)lhs, (ItemStack)rhs);
    }
}

