/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor.gui;

import gregtech.api.objects.XSTR;
import gregtech.common.items.armor.ArmorData;
import gregtech.common.items.armor.ModularArmor_Item;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryArmor
implements IInventory {
    public ItemStack[] parts = new ItemStack[16];
    public ItemStack parent;
    public int maxCharge;
    public int charge;
    public ArmorData data;

    public InventoryArmor(Class<ModularArmor_Item> class1, ItemStack currentEquippedItem) {
        this.parent = currentEquippedItem;
        this.setUID(false);
        this.readFromNBT(currentEquippedItem.getTagCompound());
        if (currentEquippedItem.getItem() instanceof ModularArmor_Item) {
            this.data = ((ModularArmor_Item)currentEquippedItem.getItem()).data;
        }
    }

    public int getSizeInventory() {
        return this.parts.length;
    }

    public ItemStack getStackInSlot(int i) {
        return this.parts[i];
    }

    public ItemStack decrStackSize(int i, int j) {
        if (this.parts[i] == null) {
            return null;
        }
        if (this.parts[i].stackSize <= j) {
            ItemStack product = this.parts[i];
            this.parts[i] = null;
            this.data.calculateArmor(this.parts);
            return product;
        }
        ItemStack product = this.parts[i].splitStack(j);
        if (this.parts[i].stackSize == 0) {
            this.parts[i] = null;
        }
        this.data.calculateArmor(this.parts);
        return product;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.parts[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.parts[slot];
        this.parts[slot] = null;
        return toReturn;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.parts[i] = itemstack;
        this.data.calculateArmor(this.parts);
    }

    public String getInventoryName() {
        return "container.armor";
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void onGuiSaved(EntityPlayer entityplayer) {
        this.parent = this.findParentInInventory(entityplayer);
        if (this.parent != null) {
            this.save();
        }
    }

    public void save() {
        NBTTagCompound nbt = this.parent.getTagCompound();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        this.writeToNBT(nbt);
        ModularArmor_Item tmp = (ModularArmor_Item)this.parent.getItem();
        tmp.data.calculateArmor(this.parts);
        this.parent.setTagCompound(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.parts[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbt.setTag("Items", (NBTBase)nbttaglist);
    }

    public ItemStack findParentInInventory(EntityPlayer player) {
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            ItemStack stack = player.inventory.getStackInSlot(i);
            if (!InventoryArmor.isIdenticalItem(stack, this.parent)) continue;
            return stack;
        }
        return this.parent;
    }

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.getItem() != rhs.getItem()) {
            return false;
        }
        if (lhs.getItemDamage() != Short.MAX_VALUE && lhs.getItemDamage() != rhs.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)lhs, (ItemStack)rhs);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.hasKey("Items")) {
            NBTTagList nbttaglist = nbt.getTagList("Items", 10);
            this.parts = new ItemStack[this.getSizeInventory()];
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                byte byte0 = nbttagcompound1.getByte("Slot");
                if (byte0 < 0 || byte0 >= this.parts.length) continue;
                this.parts[byte0] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    protected void setUID(boolean override) {
        if (this.parent.getTagCompound() == null) {
            this.parent.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbt = this.parent.getTagCompound();
        if (override || !nbt.hasKey("UID")) {
            nbt.setInteger("UID", XSTR.XSTR_INSTANCE.nextInt());
        }
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.getTagCompound();
        if (nbt == null) {
            return 0;
        }
        int count = 0;
        if (nbt.hasKey("Items")) {
            NBTTagList nbttaglist = nbt.getTagList("Items", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                ItemStack itemStack1 = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
                if (itemStack1 == null || itemStack1.stackSize <= 0) continue;
                ++count;
            }
        }
        return count;
    }
}

