/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.common.entities.GT_EntityFXPollution;
import gregtech.common.misc.GT_ClientPollutionMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GT_PollutionRenderer {
    private static GT_ClientPollutionMap pollutionMap;
    private static int playerPollution;
    private static boolean DEBUG;
    private static final int PARTICLES_MAX_NUM = 100;
    private static final int PARTICLES_POLLUTION_START = 400000;
    private static final int PARTICLES_POLLUTION_END = 3500000;
    private static final int FOG_START_AT_POLLUTION = 400000;
    private static final int FOG_MAX_AT_POLLUTION = 7000000;
    private static final double FOG_START_EXP_RATIO = 0.02;
    private static final float[] fogColor;
    private static final short[] grassColor;
    private static final short[] leavesColor;
    private static final short[] liquidColor;
    private static final short[] foliageColor;
    private static final int END_MAX_DISTANCE = 191;
    private static double fogIntensityLastTick;
    private double lastUpdate = 0.0;

    public GT_PollutionRenderer() {
        pollutionMap = new GT_ClientPollutionMap();
    }

    public void preLoad() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void processPacket(ChunkCoordIntPair chunk, int pollution) {
        pollutionMap.addChunkPollution(chunk.chunkXPos, chunk.chunkZPos, pollution);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void enteredWorld(WorldEvent.Load event) {
        EntityClientPlayerMP p = Minecraft.getMinecraft().thePlayer;
        if (!event.world.isRemote || p == null) {
            return;
        }
        pollutionMap.reset();
    }

    private static int color(int color, int pollution, int low, float high, short[] colors) {
        if (pollution < low) {
            return color;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float p = (float)(pollution - low) / high;
        if (p > 1.0f) {
            p = 1.0f;
        }
        float pi = 1.0f - p;
        r = (int)((float)r * pi + p * (float)colors[0]) & 0xFF;
        g = (int)((float)g * pi + p * (float)colors[1]) & 0xFF;
        b = (int)((float)b * pi + p * (float)colors[2]) & 0xFF;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int colorGrass(int oColor, int x, int z) {
        return GT_PollutionRenderer.color(oColor, pollutionMap.getPollution(x, z) / 1000, 350, 600.0f, grassColor);
    }

    public static int colorLeaves(int oColor, int x, int z) {
        return GT_PollutionRenderer.color(oColor, pollutionMap.getPollution(x, z) / 1000, 300, 500.0f, leavesColor);
    }

    public static int colorLiquid(int oColor, int x, int z) {
        return GT_PollutionRenderer.color(oColor, pollutionMap.getPollution(x, z) / 1000, 300, 500.0f, liquidColor);
    }

    public static int colorFoliage(int oColor, int x, int z) {
        return GT_PollutionRenderer.color(oColor, pollutionMap.getPollution(x, z) / 1000, 300, 500.0f, foliageColor);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void manipulateColor(EntityViewRenderEvent.FogColors event) {
        if (!DEBUG && Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode) {
            return;
        }
        if (event.block.getMaterial() == Material.water || event.block.getMaterial() == Material.lava) {
            return;
        }
        float x = fogIntensityLastTick > 1.0 ? 1.0f : (float)fogIntensityLastTick;
        float xi = 1.0f - x;
        event.red = xi * event.red + x * fogColor[0];
        event.green = xi * event.green + x * fogColor[1];
        event.blue = xi * event.blue + x * fogColor[2];
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGTPollutionFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (!DEBUG && Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode || fogIntensityLastTick <= 0.0 && fogIntensityLastTick >= 0.02) {
            return;
        }
        if (event.fogMode == 0) {
            double v = 1.0 - fogIntensityLastTick / 0.02;
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)((float)(128.25 * v + 20.0)));
            GL11.glFogf((int)2916, (float)((float)(191.0 * (0.75 + v * 0.25))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGTPollutionFog(EntityViewRenderEvent.FogDensity event) {
        if (!DEBUG && Minecraft.getMinecraft().thePlayer.capabilities.isCreativeMode) {
            return;
        }
        if (event.entity.isPotionActive(Potion.blindness) || fogIntensityLastTick < 0.02 || event.block.getMaterial() == Material.water || event.block.getMaterial() == Material.lava) {
            return;
        }
        GL11.glFogi((int)2917, (int)2049);
        event.density = (float)Math.pow(fogIntensityLastTick - 0.02, 0.75) / 5.0f + 0.01f;
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.thePlayer;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if ((double)event.renderTickTime < this.lastUpdate) {
                this.lastUpdate -= 1.0;
            }
            float step = (float)(((double)event.renderTickTime - this.lastUpdate) / 50.0);
            this.lastUpdate = event.renderTickTime;
            float fogIntensity = (float)(playerPollution - 400000) / 7000000.0f;
            if (fogIntensity > 1.0f) {
                fogIntensity = 1.0f;
            } else if (fogIntensity < 0.0f) {
                fogIntensity = 0.0f;
            }
            double e = (double)fogIntensity - fogIntensityLastTick;
            if (e != 0.0) {
                if (e > 0.2) {
                    e = 0.2;
                } else if (e < -0.5) {
                    e = -0.5;
                }
                fogIntensityLastTick = e > 0.001 || e < -0.001 ? (fogIntensityLastTick += (double)step * e) : (double)fogIntensity;
            }
        } else if (DEBUG) {
            this.drawPollution("Intensity: " + fogIntensityLastTick * 10000.0, 0);
            this.drawPollution("Pollution: " + pollutionMap.getPollution(Minecraft.getMinecraft().thePlayer.lastTickPosX, Minecraft.getMinecraft().thePlayer.lastTickPosZ), 20);
            this.drawPollution("Density:   " + (float)(Math.pow(fogIntensityLastTick - 0.02, 0.75) / 5.0 + (double)0.01f) * 10000.0f, 40);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.thePlayer;
        if (player == null || player.capabilities.isCreativeMode && !DEBUG) {
            return;
        }
        World w = player.worldObj;
        playerPollution = pollutionMap.getPollution(player.lastTickPosX, player.lastTickPosZ);
        float intensity = ((float)playerPollution - 400000.0f) / 3500000.0f;
        if (intensity < 0.0f) {
            return;
        }
        intensity = intensity > 1.0f ? 1.0f : (intensity *= intensity);
        int x = MathHelper.floor_double((double)player.posX);
        int y = MathHelper.floor_double((double)player.posY);
        int z = MathHelper.floor_double((double)player.posZ);
        int numParticles = Math.round(intensity * 100.0f);
        for (int l = 0; l < numParticles; ++l) {
            int k1;
            int j1;
            int i1 = x + w.rand.nextInt(16) - w.rand.nextInt(16);
            Block block = w.getBlock(i1, j1 = y + w.rand.nextInt(16) - w.rand.nextInt(16), k1 = z + w.rand.nextInt(16) - w.rand.nextInt(16));
            if (block.getMaterial() != Material.air) continue;
            GT_EntityFXPollution fx = new GT_EntityFXPollution(w, (float)i1 + w.rand.nextFloat(), (float)j1 + w.rand.nextFloat(), (float)k1 + w.rand.nextFloat());
            mc.effectRenderer.addEffect((EntityFX)fx);
        }
    }

    private void drawPollution(String text, int off) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(text, 0, off, -1);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    static {
        playerPollution = 0;
        DEBUG = false;
        fogColor = new float[]{0.3f, 0.25f, 0.1f};
        grassColor = new short[]{230, 180, 40};
        leavesColor = new short[]{160, 80, 15};
        liquidColor = new short[]{160, 200, 10};
        foliageColor = new short[]{160, 80, 15};
        fogIntensityLastTick = 0.0;
    }
}

