/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import gregtech.common.gui.GT_Container_Boiler;
import gregtech.common.gui.GT_GUIContainer_Boiler;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Boiler_Bronze
extends GT_MetaTileEntity_Boiler {
    public GT_MetaTileEntity_Boiler_Bronze(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[]{"An early way to get Steam Power", "Produces 120L of Steam per second", "Causes 20 Pollution per second"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Boiler_Bronze(int aID, String aName, String aNameRegional, String[] aDescription) {
        super(aID, aName, aNameRegional, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Boiler_Bronze(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler_Bronze(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[5][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM, Dyes.getModulation(i, Dyes._NULL.mRGBa))};
            rTextures[1][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[2][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[3][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.BOILER_FRONT)};
            rTextures[4][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.BOILER_FRONT_ACTIVE)};
        }
        return rTextures;
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Boiler(aPlayerInventory, aBaseMetaTileEntity, 16000);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Boiler(aPlayerInventory, aBaseMetaTileEntity, "BronzeBoiler.png", 16000);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Bronze(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.singleBlockBoilerLogic(aBaseMetaTileEntity, aTick, 1, 45, 25L, 20);
    }

    protected void singleBlockBoilerLogic(IGregTechTileEntity aBaseMetaTileEntity, long aTick, int aMultiplier, int aTimer, long aTickDivider, int aPollution) {
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            if (this.mTemperature <= 20) {
                this.mTemperature = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > aTimer) {
                --this.mTemperature;
                this.mLossTimer = 0;
            }
            for (byte i = 1; this.mSteam != null && i < 6; i = (byte)(i + 1)) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTileEntity;
                if (i == aBaseMetaTileEntity.getFrontFacing() || (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(i)) == null || (tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), Math.max(1, this.mSteam.amount / 2), false)) == null || (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), tDrained, false)) <= 0) continue;
                tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), tFilledAmount, true), true);
            }
            if (aTick % aTickDivider == 0L) {
                if (this.mTemperature > 100) {
                    if (this.mFluid == null || !GT_ModHandler.isWater(this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            GT_Log.exp.println("Boiler " + this.mName + " had no Water!");
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        --this.mFluid.amount;
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam(150L);
                        } else if (GT_ModHandler.isSteam(this.mSteam)) {
                            this.mSteam.amount += 150;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam(150L);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > 16000 * aMultiplier) {
                this.sendSound((byte)1);
                this.mSteam.amount = 12000 * aMultiplier;
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && this.mInventory[2] != null) {
                if (GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Coal) && !GT_Utility.isPartOfOrePrefix(this.mInventory[2], OrePrefixes.block) || GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Charcoal) && !GT_Utility.isPartOfOrePrefix(this.mInventory[2], OrePrefixes.block) || GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Lignite) && !GT_Utility.isPartOfOrePrefix(this.mInventory[2], OrePrefixes.block) || GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Diamond) && !GT_Utility.isPartOfOrePrefix(this.mInventory[2], OrePrefixes.block) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], "fuelCoke") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], "fuelCactusCharcoal") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], "fuelCactusCoke") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], "fuelSugarCharcoal") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], "fuelSugarCoke")) {
                    if (TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) / 10 > 0) {
                        this.mProcessingEnergy += TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) / 10;
                        aBaseMetaTileEntity.decrStackSize(2, 1);
                        if (XSTR.XSTR_INSTANCE.nextInt(GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Coal) || GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Charcoal) ? 3 : (GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Lignite) ? 8 : 2)) == 0) {
                            aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get(OrePrefixes.dustTiny, GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Lignite) || GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Coal) ? Materials.DarkAsh : Materials.Ash, 1L));
                        }
                    }
                } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.block.get(Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.block.get(Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.block.get(Materials.Charcoal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.block.get(Materials.Diamond)) || Block.getBlockFromItem((Item)this.mInventory[2].getItem()) != null && Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("tile") && (Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("charcoal") || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("coal") || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("diamond") || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("coke") || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("railcraft.cube") || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("lignite"))) {
                    if (TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) / 10 > 0) {
                        this.mProcessingEnergy += TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) / 10;
                        aBaseMetaTileEntity.decrStackSize(2, 1);
                        aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get(OrePrefixes.dust, GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Lignite) || GT_Utility.isPartOfMaterials(this.mInventory[2], Materials.Coal) || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("coal") || Block.getBlockFromItem((Item)this.mInventory[2].getItem()).getUnlocalizedName().toLowerCase().contains("lignite") ? Materials.DarkAsh : Materials.Ash, 1L));
                    }
                } else if (TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) >= 2000 && !this.mInventory[2].getUnlocalizedName().toLowerCase().contains("bucket") && !this.mInventory[2].getUnlocalizedName().toLowerCase().contains("cell")) {
                    this.mProcessingEnergy += TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) / 10;
                    aBaseMetaTileEntity.decrStackSize(2, 1);
                    if (XSTR.XSTR_INSTANCE.nextInt(2) == 0) {
                        aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get(TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) >= 10000 ? (TileEntityFurnace.getItemBurnTime((ItemStack)this.mInventory[2]) >= 100000 ? OrePrefixes.dust : OrePrefixes.dustSmall) : OrePrefixes.dustTiny, Materials.Ash, 1L));
                    }
                }
            }
            if (this.mTemperature < 500 * aMultiplier && this.mProcessingEnergy > 0 && aTick % 12L == 0L) {
                this.mProcessingEnergy -= aMultiplier;
                ++this.mTemperature;
            }
            if (this.mProcessingEnergy > 0 && aTick % 20L == 0L) {
                GT_Pollution.addPollution(this.getBaseMetaTileEntity(), aPollution);
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }
}

